<?php
include "../includes/header.php";
require_once "../config/db.php";

/* ======================================================
   HELPERS
======================================================*/
function get_setting($key, $default=''){
  global $conn;
  $stmt=$conn->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
  $stmt->bind_param("s",$key);
  $stmt->execute();
  $r=$stmt->get_result()->fetch_assoc();
  return $r ? htmlspecialchars($r['setting_value']) : $default;
}
function set_setting($pairs){
  global $conn;
  foreach($pairs as $k=>$v){
    $stmt=$conn->prepare("
        INSERT INTO settings (setting_key, setting_value)
        VALUES (?,?)
        ON DUPLICATE KEY UPDATE setting_value=VALUES(setting_value)
    ");
    $stmt->bind_param("ss",$k,$v);
    $stmt->execute();
  }
}

/* ======================================================
   SAVE PAGE SETTINGS
======================================================*/
if (isset($_POST['save_page'])) {
  $fields = [
    'company_name'   => $_POST['company_name'] ?? '',
    'company_slogan' => $_POST['company_slogan'] ?? '',
    'company_about'  => $_POST['company_about'] ?? '',
  ];

  // Logo upload
  if (!empty($_FILES['company_logo']['name'])) {
    $dir = "../assets/uploads/logo/";
    if(!is_dir($dir)) mkdir($dir,0755,true);
    $file = "logo_".time().".".pathinfo($_FILES['company_logo']['name'], PATHINFO_EXTENSION);
    move_uploaded_file($_FILES['company_logo']['tmp_name'], $dir.$file);
    $fields['company_logo'] = "uploads/logo/".$file;
  }

  // Banner upload
  if (!empty($_FILES['ui_banner']['name'])) {
    $dir = "../assets/uploads/ui/";
    if(!is_dir($dir)) mkdir($dir,0755,true);
    $file = "banner_".time().".".pathinfo($_FILES['ui_banner']['name'], PATHINFO_EXTENSION);
    move_uploaded_file($_FILES['ui_banner']['tmp_name'], $dir.$file);
    $fields['ui_banner'] = "uploads/ui/".$file;
  }

  set_setting($fields);
  echo "<div class='alert alert-success'>Page settings saved.</div>";
}

/* ======================================================
   SAVE SMTP
======================================================*/
if (isset($_POST['save_smtp'])) {
  set_setting([
    'smtp_host' => $_POST['smtp_host'] ?? '',
    'smtp_port' => $_POST['smtp_port'] ?? '587',
    'smtp_username' => $_POST['smtp_username'] ?? '',
    'smtp_password' => $_POST['smtp_password'] ?? '',
    'smtp_encryption' => $_POST['smtp_encryption'] ?? 'tls',
    'vgp_email_from_name' => $_POST['vgp_email_from_name'] ?? 'Visitor Gate Pass',
    'vgp_email_from_address' => $_POST['vgp_email_from_address'] ?? '',
  ]);
  echo "<div class='alert alert-success'>SMTP settings saved.</div>";
}

/* ======================================================
   SAVE GENERAL (NOW WITH NOTIFICATION EMAILS)
======================================================*/
if (isset($_POST['save_general'])) {
  set_setting([
    'overstay_limit_hours'  => $_POST['overstay_limit_hours'] ?? '2',
    'overstay_alert_emails' => $_POST['overstay_alert_emails'] ?? '',

    /* NEW NOTIFICATION FIELDS */
    'notify_checkin_emails'   => $_POST['notify_checkin_emails'] ?? '',
    'notify_induction_emails' => $_POST['notify_induction_emails'] ?? '',
    'notify_checkout_emails'  => $_POST['notify_checkout_emails'] ?? '',
    'notify_expected_emails'  => $_POST['notify_expected_emails'] ?? '',
    'notify_returning_emails' => $_POST['notify_returning_emails'] ?? '',
  ]);

  echo "<div class='alert alert-success'>General settings saved.</div>";
}
?>

<h3 class="mb-3">System Settings</h3>

<ul class="nav nav-tabs mb-3" id="settingsTabs" role="tablist">
  <li class="nav-item">
    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#page">Page Settings</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#smtp">SMTP Settings</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#general">General</button>
  </li>
</ul>

<div class="tab-content">

  <!-- ======================================================
       PAGE SETTINGS
  =======================================================-->
  <div class="tab-pane fade show active" id="page">
    <form method="POST" enctype="multipart/form-data" class="card p-3">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Company Name</label>
          <input name="company_name" value="<?php echo get_setting('company_name'); ?>" class="form-control">
        </div>

        <div class="col-md-6">
          <label class="form-label">Company Slogan</label>
          <input name="company_slogan" value="<?php echo get_setting('company_slogan'); ?>" class="form-control">
        </div>

        <div class="col-12">
          <label class="form-label">About Company</label>
          <textarea name="company_about" rows="3" class="form-control"><?php echo get_setting('company_about'); ?></textarea>
        </div>

        <div class="col-md-6">
          <label class="form-label">Company Logo</label>
          <input type="file" name="company_logo" accept="image/*" class="form-control">
          <?php if (get_setting('company_logo')): ?>
            <img src="../assets/<?php echo get_setting('company_logo'); ?>" class="mt-2" style="height:60px">
          <?php endif; ?>
        </div>

        <div class="col-md-6">
          <label class="form-label">UI Banner / Background</label>
          <input type="file" name="ui_banner" accept="image/*" class="form-control">
          <?php if (get_setting('ui_banner')): ?>
            <img src="../assets/<?php echo get_setting('ui_banner'); ?>" class="mt-2 img-fluid rounded" style="max-height:120px">
          <?php endif; ?>
        </div>
      </div>

      <div class="text-end mt-3">
        <button class="btn btn-primary" name="save_page">Save Page</button>
      </div>
    </form>
  </div>


  <!-- ======================================================
       SMTP SETTINGS
  =======================================================-->
  <div class="tab-pane fade" id="smtp">
    <form method="POST" class="card p-3">
      <div class="row g-3">

        <div class="col-md-4">
          <label class="form-label">SMTP Host</label>
          <input name="smtp_host" value="<?php echo get_setting('smtp_host'); ?>" class="form-control">
        </div>

        <div class="col-md-2">
          <label class="form-label">Port</label>
          <input name="smtp_port" value="<?php echo get_setting('smtp_port','587'); ?>" class="form-control">
        </div>

        <div class="col-md-3">
          <label class="form-label">Encryption</label>
          <select name="smtp_encryption" class="form-select">
            <?php foreach(['tls','ssl','none'] as $e): ?>
              <option value="<?php echo $e; ?>" <?php if(get_setting('smtp_encryption')===$e) echo 'selected'; ?>>
                <?php echo strtoupper($e); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">SMTP Username</label>
          <input name="smtp_username" value="<?php echo get_setting('smtp_username'); ?>" class="form-control">
        </div>

        <div class="col-md-6">
          <label class="form-label">SMTP Password</label>
          <input type="password" name="smtp_password" value="<?php echo get_setting('smtp_password'); ?>" class="form-control">
        </div>

        <div class="col-md-6">
          <label class="form-label">Sender Name</label>
          <input name="vgp_email_from_name" value="<?php echo get_setting('vgp_email_from_name','Visitor Gate Pass'); ?>" class="form-control">
        </div>

        <div class="col-md-6">
          <label class="form-label">Sender Email</label>
          <input type="email" name="vgp_email_from_address" value="<?php echo get_setting('vgp_email_from_address'); ?>" class="form-control">
        </div>

      </div>

      <div class="text-end mt-3">
        <button class="btn btn-primary" name="save_smtp">Save SMTP</button>
      </div>
    </form>
  </div>


  <!-- ======================================================
       GENERAL SETTINGS (Now includes notification emails)
  =======================================================-->
  <div class="tab-pane fade" id="general">
    <form method="POST" class="card p-3">
      <div class="row g-3">

        <!-- Overstay settings -->
        <div class="col-md-4">
          <label class="form-label">Overstay Limit (hours)</label>
          <input type="number" name="overstay_limit_hours" step="0.5" min="0"
                 value="<?php echo get_setting('overstay_limit_hours','4'); ?>" class="form-control">
        </div>

        <div class="col-md-8">
          <label class="form-label">Overstay Alert Emails</label>
          <input name="overstay_alert_emails" value="<?php echo get_setting('overstay_alert_emails',''); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

        <hr class="mt-4">

        <h5 class="text-primary">📨 Notification Recipients</h5>

        <div class="col-md-6">
          <label class="form-label">Visitor Check-In Emails</label>
          <input name="notify_checkin_emails"
                 value="<?php echo get_setting('notify_checkin_emails'); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

        <div class="col-md-6">
          <label class="form-label">Induction Notification Emails</label>
          <input name="notify_induction_emails"
                 value="<?php echo get_setting('notify_induction_emails'); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

        <div class="col-md-6">
          <label class="form-label">Visitor Checkout Emails</label>
          <input name="notify_checkout_emails"
                 value="<?php echo get_setting('notify_checkout_emails'); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

        <div class="col-md-6">
          <label class="form-label">Expected Visitor Emails</label>
          <input name="notify_expected_emails"
                 value="<?php echo get_setting('notify_expected_emails'); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

        <div class="col-md-6">
          <label class="form-label">Returning Visitor Emails</label>
          <input name="notify_returning_emails"
                 value="<?php echo get_setting('notify_returning_emails'); ?>"
                 class="form-control" placeholder="comma-separated">
        </div>

      </div>

      <div class="text-end mt-3">
        <button class="btn btn-primary" name="save_general">Save General</button>
      </div>
    </form>
  </div>

</div>


<script>
// make tab open by hash #smtp or #general
const target = location.hash?.replace('#','');
if (target) {
  const btn = document.querySelector(`[data-bs-target="#${target}"]`);
  if (btn) new bootstrap.Tab(btn).show();
}
</script>

<?php include "../includes/footer.php"; ?>