<?php
// app/controllers/checkedinController.php

// Permission: viewing checked-in visitors
if (!user_has_permission('view_checkedin')) {
    http_response_code(403);
    include __DIR__ . '/../views/403.php';
    exit;
}

$visitorModel = new Visitor($conn);

// Fetch checked-in visitor records
$checkedin = $visitorModel->getCheckedInVisitors();

$page_title = "Checked-In Visitors";

// Load layout
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/checkedin.php';
include __DIR__ . '/../views/layouts/footer.php';