<?php

require_permission('manage_employees');

$employeeModel    = new Employee($conn);
$departmentModel  = new Department($conn);

$employees   = $employeeModel->getAll();
$departments = $departmentModel->getAll();

$editData = null;

// Edit request
if (isset($_GET['edit'])) {
    $editData = $employeeModel->find($_GET['edit']);
}

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name         = trim($_POST['name']);
    $email        = trim($_POST['email']);
    $phone        = trim($_POST['phone']);
    $departmentId = intval($_POST['department_id']);

    if (!empty($_POST['id'])) {
        // Update
        $employeeModel->update($_POST['id'], $name, $email, $phone, $departmentId);
    } else {
        // Create
        $employeeModel->create($name, $email, $phone, $departmentId);
    }

    header("Location: index.php?page=employees");
    exit;
}

// Delete request
if (isset($_GET['delete'])) {
    $employeeModel->delete($_GET['delete']);
    header("Location: index.php?page=employees");
    exit;
}

// LOAD LAYOUT
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/layouts/sidebar.php';
include __DIR__ . '/../views/employees.php';
include __DIR__ . '/../views/layouts/footer.php';