<?php
// app/controllers/settingsController.php

$page_title = "System Settings";

$activeTab = $_GET['tab'] ?? 'page';   // page | smtp | general
$success   = "";
$error     = "";

// ---------------------------------------------------------
// Handle POST per-tab
// ---------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    switch ($activeTab) {

        // ---------------- PAGE SETTINGS ----------------
        case 'page':

            setting_set('company_name',    trim($_POST['company_name']    ?? ''));
            setting_set('company_email',   trim($_POST['company_email']   ?? ''));
            setting_set('company_phone',   trim($_POST['company_phone']   ?? ''));
            setting_set('company_address', trim($_POST['company_address'] ?? ''));
            setting_set('footer_text',     trim($_POST['footer_text']     ?? ''));
            setting_set('theme',           trim($_POST['theme']           ?? 'light'));

            // Logo upload (optional)
            if (!empty($_FILES['company_logo']['name'])) {

                $uploadDir  = __DIR__ . '/../../assets/images/';
                $fileName   = 'logo-custom-' . time() . '.png';
                $targetPath = $uploadDir . $fileName;

                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                $tmp = $_FILES['company_logo']['tmp_name'];
                $check = @getimagesize($tmp);

                if ($check !== false) {
                    if (move_uploaded_file($tmp, $targetPath)) {
                        $publicPath = 'assets/images/' . $fileName;
                        setting_set('company_logo', $publicPath);
                    } else {
                        $error = "Logo upload failed.";
                    }
                } else {
                    $error = "Invalid logo file. Please upload an image.";
                }
            }

            if (!$error) {
                $success = "Page settings updated successfully.";
            }

            break;

        // ---------------- SMTP SETTINGS ----------------
        case 'smtp':

            setting_set('smtp_host',       trim($_POST['smtp_host']       ?? ''));
            setting_set('smtp_port',       trim($_POST['smtp_port']       ?? ''));
            setting_set('smtp_username',   trim($_POST['smtp_username']   ?? ''));
            setting_set('smtp_password',   trim($_POST['smtp_password']   ?? ''));
            setting_set('smtp_encryption', trim($_POST['smtp_encryption'] ?? ''));
            setting_set('smtp_from_name',  trim($_POST['smtp_from_name']  ?? ''));
            setting_set('smtp_from_email', trim($_POST['smtp_from_email'] ?? ''));

            $success = "SMTP settings updated successfully.";
            break;

        // ---------------- GENERAL SETTINGS -------------
        case 'general':

            setting_set('overstay_limit',        trim($_POST['overstay_limit']        ?? ''));
            setting_set('overstay_alert_emails', trim($_POST['overstay_alert_emails'] ?? ''));

            setting_set('notify_checkin',   trim($_POST['notify_checkin']   ?? ''));
            setting_set('notify_induction', trim($_POST['notify_induction'] ?? ''));
            setting_set('notify_checkout',  trim($_POST['notify_checkout']  ?? ''));
            setting_set('notify_expected',  trim($_POST['notify_expected']  ?? ''));
            setting_set('notify_returning', trim($_POST['notify_returning'] ?? ''));

            $success = "General settings updated successfully.";
            break;
    }
}

// ---------------------------------------------------------
// Load current values for the form
// ---------------------------------------------------------
$settings = [
    'company_name'    => setting('company_name', 'Visitor Gate Pass'),
    'company_email'   => setting('company_email', ''),
    'company_phone'   => setting('company_phone', ''),
    'company_address' => setting('company_address', ''),
    'footer_text'     => setting('footer_text', '© ' . date('Y') . ' Visitor Gate Pass'),
    'theme'           => setting('theme', 'light'),

    'smtp_host'       => setting('smtp_host', ''),
    'smtp_port'       => setting('smtp_port', '587'),
    'smtp_username'   => setting('smtp_username', ''),
    'smtp_password'   => setting('smtp_password', ''),
    'smtp_encryption' => setting('smtp_encryption', 'tls'),
    'smtp_from_name'  => setting('smtp_from_name', ''),
    'smtp_from_email' => setting('smtp_from_email', ''),

    'company_logo'    => setting('company_logo', 'assets/images/logo.png'),
];

// ---------------------------------------------------------
// Render view
// ---------------------------------------------------------
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/settings.php';
include __DIR__ . '/../views/layouts/footer.php';