<?php
// app/controllers/visitor-deleteController.php

if (!user_has_permission('visitor_delete')) {
    http_response_code(403);
    include __DIR__ . '/../views/403.php';
    exit;
}

// Validate ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$visitorModel = new Visitor($conn);
$visitor = $visitorModel->find($id);

// If visitor doesn't exist → 404
if (!$visitor) {
    http_response_code(404);
    include __DIR__ . '/../views/404.php';
    exit;
}

// Delete visitor
$visitorModel->delete($id);

// Redirect back to Visitors page with success flag
header("Location: index.php?page=visitors&deleted=1");
exit;