<?php
// app/controllers/visitor-viewController.php

require_permission('reports_view'); // you already fixed this

$visitorId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$visitorId) {
    include __DIR__ . '/../views/404.php';
    exit;
}

$stmt = $conn->prepare("
    SELECT v.*,
           e.name AS host_name,
           d.name AS department_name
    FROM visitors v
    LEFT JOIN employees  e ON v.host_id = e.id
    LEFT JOIN departments d ON v.department_id = d.id
    WHERE v.id = ?
    LIMIT 1
");
$stmt->bind_param("i", $visitorId);
$stmt->execute();
$result = $stmt->get_result();
$visitor = $result->fetch_assoc();
$stmt->close();

if (!$visitor) {
    include __DIR__ . '/../views/404.php';
    exit;
}

$page_title = "Visitor Details";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/visitor-view.php';
include __DIR__ . '/../views/layouts/footer.php';