<?php

/**
 * Check if logged-in user has a given permission.
 *
 * New RBAC structure:
 * users.role_id → role_permissions.role_id → permissions.id
 */

function user_has_permission($permission_key)
{
    if (!isset($_SESSION['username'])) {
        return false;
    }

    global $conn;

    $username = $_SESSION['username'];

    // 1. Get user role_id
    $stmt = $conn->prepare("
        SELECT role_id 
        FROM users 
        WHERE username = ? 
        LIMIT 1
    ");
    $stmt->bind_param("s", $username);
    $stmt->execute();

    $stmt->bind_result($role_id);
    $stmt->fetch();
    $stmt->close();

    if (!$role_id) {
        return false;
    }

    // 2. Check if this role has the given permission
    $stmt = $conn->prepare("
        SELECT COUNT(*)
        FROM role_permissions rp
        JOIN permissions p ON rp.permission_id = p.id
        WHERE rp.role_id = ?
        AND p.key = ?
    ");
    $stmt->bind_param("is", $role_id, $permission_key);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();
    $stmt->close();

    return ($count > 0);
}


/**
 * Redirect user if they do NOT have required permission.
 */
function require_permission($key)
{
    if (!user_has_permission($key)) {
        include __DIR__ . '/../views/403.php';
        exit;
    }
}