<?php

require_once __DIR__ . '/qrmask.php';   // This will load qrmatrix only once

class QRcode {

    public static function png($text, $outfile = false, $level = QR_ECLEVEL_L, $size = 3, $margin = 4)
    {
        $enc = QRencode::factory($level, $size, $margin);
        return $enc->encodePNG($text, $outfile);
    }
}

define('QR_ECLEVEL_L', 0);
define('QR_ECLEVEL_M', 1);
define('QR_ECLEVEL_Q', 2);
define('QR_ECLEVEL_H', 3);

class QRencode {

    public $level;
    public $size;
    public $margin;

    public static function factory($level, $size, $margin)
    {
        $enc = new QRencode();
        $enc->level = $level;
        $enc->size = $size;
        $enc->margin = $margin;
        return $enc;
    }

    public function encodePNG($text, $outfile = false)
    {
        // QRmask loads qrmatrix already
        $qr = QRmatrix::text($text, $this->level);

        $image = $qr->createImage($this->size, $this->margin);

        if ($outfile !== false) {
            imagepng($image, $outfile);
        } else {
            header('Content-Type: image/png');
            imagepng($image);
        }

        imagedestroy($image);
        return true;
    }
}