<?php

class Role
{
    private $conn;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    public function all()
    {
        return $this->conn->query("SELECT * FROM roles ORDER BY id ASC");
    }

    public function find($id)
    {
        $stmt = $this->conn->prepare("SELECT * FROM roles WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function create($name, $slug)
    {
        $stmt = $this->conn->prepare("INSERT INTO roles (name, slug) VALUES (?, ?)");
        $stmt->bind_param("ss", $name, $slug);
        return $stmt->execute();
    }

    public function update($id, $name, $slug)
    {
        $stmt = $this->conn->prepare("UPDATE roles SET name = ?, slug = ? WHERE id = ?");
        $stmt->bind_param("ssi", $name, $slug, $id);
        return $stmt->execute();
    }

    public function delete($id)
    {
        $stmt = $this->conn->prepare("DELETE FROM roles WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }

    public function getAssignedPermissions($id)
    {
        $stmt = $this->conn->prepare("
            SELECT p.id, p.key, p.description
            FROM role_permissions rp
            JOIN permissions p ON rp.permission_id = p.id
            WHERE rp.role_id = ?
        ");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result();
    }
}