<div class="container py-4">

    <div class="row">

        <!-- LEFT SIDE: PASSWORD FORM -->
        <div class="col-md-6">

            <h2 class="mb-2">Change Password</h2>
            <p class="text-muted">Update your account password securely.</p>

            <div class="card shadow-sm mt-3">
                <div class="card-body">

                    <div class="mx-auto" style="max-width: 500px;">

                        <?php if (!empty($error)): ?>
                            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                        <?php endif; ?>

                        <?php if (!empty($success)): ?>
                            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
                        <?php endif; ?>

                        <form method="post">

                            <div class="mb-3">
                                <label class="form-label">Old Password</label>
                                <input type="password" name="old_password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">New Password</label>
                                <input type="password" name="new_password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Confirm New Password</label>
                                <input type="password" name="confirm_password" class="form-control">
                            </div>

                            <button class="btn btn-primary px-4">Update Password</button>

                        </form>

                    </div>

                </div>
            </div>

        </div>

        <!-- RIGHT SIDE: IMAGE AREA -->
        <div class="col-md-6 d-flex align-items-center justify-content-center">
            <img src="assets/images/change-password-art.png"
                 alt="Security Illustration"
                 style="max-width: 80%; opacity: 0.9;">
        </div>

    </div>

    <!-- FOOTER -->
    <div class="text-center text-muted mt-4">
        © <?= date('Y') ?> Visitor Gate Pass
    </div>

</div>