<div class="container-fluid">

<h3 class="mb-4">Employees / Hosts</h3>
<?php if (isset($_GET['uploaded'])): ?>
<div class="alert alert-success">
    Employees imported successfully.
</div>
<?php endif; ?>

<div class="row">

    <!-- FORM -->
    <div class="col-md-4">
        <div class="card shadow-sm">
            <div class="card-header bg-white fw-semibold">
                Add / Edit Employee
            </div>

            <div class="card-body">

                <form method="post">

                    <input type="hidden" name="id" value="<?= $editData['id'] ?? '' ?>">

                    <div class="mb-3">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="name" class="form-control"
                               value="<?= htmlspecialchars($editData['name'] ?? '') ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control"
                               value="<?= htmlspecialchars($editData['email'] ?? '') ?>">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Phone</label>
                        <input type="text" name="phone" class="form-control"
                               value="<?= htmlspecialchars($editData['phone'] ?? '') ?>">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Department</label>

                        <select name="department_id" class="form-select">
                            <option value="">-- None --</option>

                            <?php while ($d = $departments->fetch_assoc()): ?>
                                <option value="<?= $d['id'] ?>"
                                    <?= (isset($editData['department_id']) && $editData['department_id'] == $d['id']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($d['name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <button class="btn btn-primary">Save</button>
                    <a href="index.php?page=employees" class="btn btn-secondary">Clear</a>

                </form>

            </div>
        </div>

        <!-- CSV UPLOAD -->
        <div class="card shadow-sm mt-4">
            <div class="card-header bg-white fw-semibold">
                Bulk Upload (CSV)
            </div>

            <div class="card-body">
                <p class="text-muted">CSV columns: <strong>name,email,phone,department</strong></p>

                <form method="post" enctype="multipart/form-data" 
                      action="index.php?page=employees-csv">

                    <input type="file" name="csv_file" class="form-control mb-2" required>
                    <button class="btn btn-success">Upload</button>

                </form>
            </div>
        </div>

    </div>

    <!-- TABLE -->
    <div class="col-md-8">
        <div class="card shadow-sm">
            <div class="card-body">

                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Department</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $i = 1; while ($e = $employees->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= htmlspecialchars($e['name']) ?></td>
                            <td><?= htmlspecialchars($e['email']) ?></td>
                            <td><?= htmlspecialchars($e['phone']) ?></td>
                            <td><?= htmlspecialchars($e['department_name'] ?? '') ?></td>

                            <td>
                                <a href="index.php?page=employees&edit=<?= $e['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                                <a href="index.php?page=employees&delete=<?= $e['id'] ?>" 
                                   onclick="return confirm('Delete this employee?')"
                                   class="btn btn-sm btn-danger">Delete</a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>

                </table>

            </div>
        </div>
    </div>

</div>

</div>