<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= htmlspecialchars($page_title ?? setting('company_name', 'Visitor Gate Pass')) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    body {
        background:#f3f5f9;
        margin:0;
        padding:0;
    }

    /* Sidebar */
    .sidebar {
        width:260px;
        height:100vh;
        position:fixed;
        overflow-y:auto;
    }

    .sidebar .nav-link {
        padding:10px 20px;
        color:#333;
    }

    .sidebar .nav-link.active {
        background:#0d6efd;
        color:#fff;
        border-radius:6px;
    }

    .menu-section {
        font-size:11px;
        color:#888;
        padding:8px 20px;
        margin-top:20px;
        text-transform:uppercase;
    }

    /* TOPBAR Styling */
    .topbar {
        position: fixed;
        left: 260px;
        right: 0;
        top: 0;
        height: 60px;
        background: white;
        border-bottom: 1px solid #e6e6e6;
        z-index: 2000;
    }

    .content-area {
        margin-left:260px;
        padding:100px 40px 40px;
    }
    /* Restore strong sidebar hover */
.sidebar .nav-link {
    padding: 10px 20px;
    color: #333;
    transition: background .15s ease, color .15s ease;
    border-radius: 6px;
}

.sidebar .nav-link:hover {
    background: #e8f0ff !important;   /* light blue hover */
    color: #003399 !important;        /* bootstrap primary blue */
}

/* Active link highlight */
.sidebar .nav-link.active {
    background: #0d6efd !important;
    color: #fff !important;
    border-radius: 6px;
}
  </style>
</head>

<body>

<?php include __DIR__ . '/sidebar.php'; ?>

<!-- Top Navigation Bar -->
<nav class="topbar d-flex align-items-center justify-content-between px-4">
    
    <!-- LEFT BRANDING (Dynamic Name & Logo) -->
        <span class="fw-semibold fs-5">
            <?= htmlspecialchars(setting('company_name','Visitor Gate Pass')) ?>
        </span>
    </div>

    <!-- RIGHT SECTION -->
    <div class="d-flex align-items-center gap-4">

        <a href="index.php?page=checkout" class="btn btn-outline-danger btn-sm">
            <i class="bi bi-box-arrow-right"></i> Check-Out
        </a>

        <div class="dropdown">
            <button class="btn btn-light rounded-pill px-3 dropdown-toggle" data-bs-toggle="dropdown">
                <i class="bi bi-person-circle me-1"></i>
                <?= htmlspecialchars($_SESSION['username'] ?? 'Account') ?>
            </button>

            <ul class="dropdown-menu dropdown-menu-end shadow">
                <li class="dropdown-header small text-muted">
                    Logged in as <strong><?= htmlspecialchars($_SESSION['username'] ?? '') ?></strong>
                </li>

                <li>
                    <a class="dropdown-item" href="index.php?page=change-password">
                        <i class="bi bi-key me-2"></i> Change Password
                    </a>
                </li>

                <li><hr class="dropdown-divider"></li>

                <li>
                    <a class="dropdown-item text-danger" href="index.php?page=logout">
                        <i class="bi bi-box-arrow-right me-2"></i> Logout
                    </a>
                </li>
            </ul>
        </div>

    </div>

</nav>

<div class="content-area">