<?php
// app/views/visitor-edit.php
?>

<div class="row mb-4">
  <div class="col-12 d-flex justify-content-between align-items-center">
    <h2>Edit Visitor</h2>
    <a href="index.php?page=visitor-view&id=<?= $visitor['id'] ?>" class="btn btn-secondary">Back to Details</a>
  </div>
</div>

<div class="row">
  <div class="col-lg-8">

    <?php if (!empty($success)): ?>
      <div class="alert alert-success"><?= $success ?></div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <div class="card shadow-sm">
      <div class="card-body">

        <form method="post">

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Full Name</label>
              <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($visitor['name']) ?>" required>
            </div>

            <div class="col-md-6 mb-3">
              <label class="form-label">Phone</label>
              <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($visitor['phone']) ?>" required>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($visitor['email']) ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label class="form-label">Company</label>
              <input type="text" name="company" class="form-control" value="<?= htmlspecialchars($visitor['company']) ?>">
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Gender</label>
              <select name="gender" class="form-select">
                <option value="">-- Select --</option>
                <option value="Male" <?= $visitor['gender']=='Male' ? 'selected' : '' ?>>Male</option>
                <option value="Female" <?= $visitor['gender']=='Female' ? 'selected' : '' ?>>Female</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label class="form-label">Purpose</label>
              <input type="text" name="purpose" class="form-control" value="<?= htmlspecialchars($visitor['purpose']) ?>">
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Items Declared</label>
            <input type="text" name="items_declared" class="form-control" value="<?= htmlspecialchars($visitor['items_declared']) ?>">
          </div>

          <div class="mb-3">
            <label class="form-label">Tag Number</label>
            <input type="text" name="tag_number" class="form-control" value="<?= htmlspecialchars($visitor['tag_number']) ?>">
          </div>

          <div class="mb-3">
            <label class="form-label">Address</label>
            <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($visitor['address']) ?></textarea>
          </div>

          <div class="row">
            <div class="col-md-6 mb-3">
              <label class="form-label">Host</label>
              <select name="host_id" class="form-select" required>
                <option value="">-- Select Host --</option>
                <?php while($h = $hosts->fetch_assoc()): ?>
                  <option value="<?= $h['id'] ?>" <?= $visitor['host_id']==$h['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($h['name']) ?>
                  </option>
                <?php endwhile; ?>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label class="form-label">Department</label>
              <select name="department_id" class="form-select" required>
                <option value="">-- Select Department --</option>
                <?php while($d = $departments->fetch_assoc()): ?>
                  <option value="<?= $d['id'] ?>" <?= $visitor['department_id']==$d['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($d['name']) ?>
                  </option>
                <?php endwhile; ?>
              </select>
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Save Changes</button>

        </form>

      </div>
    </div>
  </div>

  <div class="col-lg-4">
    <div class="card shadow-sm">
      <div class="card-body text-center">
        <h6>Current Photo</h6>
        <?php if ($visitor['photo']): ?>
          <img src="<?= htmlspecialchars($visitor['photo']) ?>" class="img-fluid rounded">
        <?php else: ?>
          <p class="text-muted">No photo available</p>
        <?php endif; ?>
      </div>
    </div>
  </div>

</div>