<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/pagination.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

/* =========================================
   FILTERS
========================================= */
$status = $_GET['status'] ?? '';
$q      = trim($_GET['q'] ?? '');
$from   = $_GET['from'] ?? '';
$to     = $_GET['to'] ?? '';

$where = [];
$args  = [];
$types = '';

if ($status !== '' && in_array($status, ['expected','checked_in','checked_out','returning'])) {
  $where[] = "v.status = ?";
  $args[]  = $status; $types .= 's';
}

if ($q !== '') {
  $where[] = "(v.name LIKE ? OR v.phone LIKE ? OR v.email LIKE ?)";
  $args[] = "%$q%"; 
  $args[] = "%$q%";
  $args[] = "%$q%";
  $types .= 'sss';
}

if ($from !== '') { $where[] = "(DATE(v.checkin_date) >= ?)"; $args[] = $from; $types .= 's'; }
if ($to   !== '') { $where[] = "(DATE(v.checkin_date) <= ?)"; $args[] = $to;   $types .= 's'; }

$sqlWhere = $where ? ('WHERE '.implode(' AND ', $where)) : '';

/* =========================================
   PAGINATION
========================================= */
$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

/* Count total */
$count_sql = "SELECT COUNT(*) AS total FROM visitors v $sqlWhere";
$count_stmt = $conn->prepare($count_sql);
if ($args) $count_stmt->bind_param($types, ...$args);
$count_stmt->execute();
$total = $count_stmt->get_result()->fetch_assoc()['total'];

/* Fetch paginated data */
$sql = "
SELECT 
  v.*, 
  e.name AS host_name,
  d.name AS department_name
FROM visitors v
LEFT JOIN employees e ON e.id=v.host_id
LEFT JOIN departments d ON d.id=v.department_id
$sqlWhere
ORDER BY v.id DESC
LIMIT $limit OFFSET $offset
";

$stmt = $conn->prepare($sql);
if ($args) $stmt->bind_param($types, ...$args);
$stmt->execute();
$res = $stmt->get_result();
?>
<h3 class="mb-3">Visitor Report</h3>

<div class="card p-3 mb-3">
<form method="GET" class="row g-2">
  <div class="col-md-2">
    <label class="form-label">From</label>
    <input type="date" name="from" value="<?php echo htmlspecialchars($from); ?>" class="form-control">
  </div>
  <div class="col-md-2">
    <label class="form-label">To</label>
    <input type="date" name="to" value="<?php echo htmlspecialchars($to); ?>" class="form-control">
  </div>
  <div class="col-md-3">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
      <option value="">All</option>
      <?php foreach (['expected','checked_in','checked_out','returning'] as $s): ?>
      <option value="<?php echo $s; ?>" <?php if($status===$s) echo 'selected'; ?>>
        <?php echo ucfirst(str_replace('_',' ',$s)); ?>
      </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Search</label>
    <input name="q" value="<?php echo htmlspecialchars($q); ?>" class="form-control" placeholder="Name/Phone/Email">
  </div>
  <div class="col-md-2 d-flex align-items-end gap-2">
    <button class="btn btn-primary w-100"><i class="bi bi-search"></i></button>
  </div>
</form>
</div>

<?php
$currentPage = $page;
$totalPages  = ceil($total / $limit);
?>

<div class="card p-0">
  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>

          <!-- NEW PHOTO COLUMN -->
          <th>Photo</th>

          <th>Name</th>
          <th>Phone</th>
          <th>Email</th>
          <th>Company</th>
          <th>Gender</th>
          <th>Host</th>
          <th>Department</th>
          <th>Tag #</th>
          <th>Status</th>
          <th>Check-In</th>
          <th>Check-Out</th>
        </tr>
      </thead>

      <tbody>
        <?php 
        $i = $offset + 1;
        while ($row = $res->fetch_assoc()):
        ?>
          <tr>
            <td><?php echo $i++; ?></td>

            <!-- PHOTO DISPLAY -->
            <td>
              <?php if (!empty($row['photo'])): ?>
                <img src="/<?php echo $row['photo']; ?>"
                     style="width:45px;height:45px;object-fit:cover;border-radius:6px;">
              <?php else: ?>
                <span class="text-muted small">No photo</span>
              <?php endif; ?>
            </td>

            <td><?php echo htmlspecialchars($row['name']); ?></td>
            <td><?php echo htmlspecialchars($row['phone']); ?></td>
            <td><?php echo htmlspecialchars($row['email']); ?></td>

            <td><?php echo htmlspecialchars($row['company'] ?: '-'); ?></td>
            <td><?php echo htmlspecialchars($row['gender'] ?: '-'); ?></td>

            <td><?php echo htmlspecialchars($row['host_name'] ?: '-'); ?></td>
            <td><?php echo htmlspecialchars($row['department_name'] ?: '-'); ?></td>

            <td><?php echo htmlspecialchars($row['tag_number'] ?: '-'); ?></td>

            <td>
              <span class="badge bg-<?php
                echo $row['status']==='checked_in'  ? 'success' :
                     ($row['status']==='expected'   ? 'secondary' :
                     ($row['status']==='returning'  ? 'info' :
                     ($row['status']==='checked_out'? 'dark' : 'light')));
              ?>">
                <?php echo ucfirst(str_replace('_',' ', $row['status'])); ?>
              </span>
            </td>

            <td><?php echo $row['checkin_date'].' '.$row['checkin_time']; ?></td>
            <td><?php echo $row['checkout_time'] ?: '-'; ?></td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <?php echo pagination_links($currentPage, $totalPages); ?>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>