<?php include __DIR__ . '/../includes/header.php'; echo "\n<?php\nif (function_exists('require_roles')) {\n  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);\n}\n?>\n"; require_once __DIR__ . '/../config/db.php';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name=trim($_POST['name']??''); $desc=trim($_POST['description']??''); $id=(int)($_POST['id']??0);
  if ($name!=='') {
    if ($id>0) { $stmt=$conn->prepare("UPDATE departments SET name=?, description=? WHERE id=?"); $stmt->bind_param("ssi",$name,$desc,$id); $stmt->execute(); $msg="Department updated."; }
    else { $stmt=$conn->prepare("INSERT INTO departments(name,description) VALUES(?,?)"); $stmt->bind_param("ss",$name,$desc); $stmt->execute(); $msg="Department added."; }
  }
}
if (($_GET['action']??'')==='delete' && isset($_GET['id'])) { $conn->query("DELETE FROM departments WHERE id=".(int)$_GET['id']); $msg="Department deleted."; }
$res=$conn->query("SELECT id,name,description FROM departments ORDER BY name ASC");
?>
<h3 class="mb-3">Departments</h3>
<?php if(!empty($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card p-3">
      <h5 class="mb-3">Add / Edit Department</h5>
      <form method="POST">
        <input type="hidden" name="id" id="dept_id">
        <div class="mb-3"><label class="form-label">Name</label><input class="form-control" name="name" id="dept_name" required></div>
        <div class="mb-3"><label class="form-label">Description</label><textarea class="form-control" name="description" id="dept_desc" rows="3"></textarea></div>
        <div class="d-flex gap-2"><button class="btn btn-primary">Save</button><button type="button" class="btn btn-secondary" onclick="clearDept()">Clear</button></div>
      </form>
    </div>
  </div>
  <div class="col-md-7">
    <div class="card p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
          <thead class="table-light"><tr><th>#</th><th>Name</th><th>Description</th><th>Action</th></tr></thead>
          <tbody>
            <?php $i=1; while($r=$res->fetch_assoc()): ?>
            <tr>
              <td><?php echo $i++; ?></td>
              <td><?php echo htmlspecialchars($r['name']); ?></td>
              <td><?php echo htmlspecialchars($r['description']); ?></td>
              <td class="text-nowrap">
                <button class="btn btn-sm btn-outline-primary" onclick="editDept(<?php echo $r['id']; ?>,'<?php echo htmlspecialchars($r['name'],ENT_QUOTES); ?>','<?php echo htmlspecialchars($r['description'],ENT_QUOTES); ?>')">Edit</button>
                <a class="btn btn-sm btn-outline-danger" href="?action=delete&id=<?php echo $r['id']; ?>" onclick="return confirm('Delete this department?')">Delete</a>
              </td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
function editDept(id,name,desc){
  document.getElementById('dept_id').value=id;
  document.getElementById('dept_name').value=name;
  document.getElementById('dept_desc').value=desc;
  window.scrollTo({top:0, behavior:'smooth'});
}
function clearDept(){
  document.getElementById('dept_id').value='';
  document.getElementById('dept_name').value='';
  document.getElementById('dept_desc').value='';
}
</script>
<?php include __DIR__ . '/../includes/footer.php'; ?>
