<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

$msg = $err = '';

/** create/find department by name -> id */
function upsert_department($name, $conn) {
  $name = trim($name);
  if ($name === '') return null;
  $stmt = $conn->prepare("SELECT id FROM departments WHERE name=? LIMIT 1");
  $stmt->bind_param("s", $name);
  $stmt->execute();
  $res = $stmt->get_result()->fetch_assoc();
  if ($res) return (int)$res['id'];
  $ins = $conn->prepare("INSERT INTO departments (name) VALUES (?)");
  $ins->bind_param("s", $name);
  $ins->execute();
  return $ins->insert_id;
}

/** BULK CSV UPLOAD */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csv_upload'])) {
  if (!empty($_FILES['csv']['name'])) {
    $added = $skipped = $dept_created = 0;
    if (($h = fopen($_FILES['csv']['tmp_name'], 'r')) !== false) {
      // optional header row detection
      $first = fgetcsv($h);
      $maybeHeader = array_map('strtolower', $first);
      $hasHeader = in_array('name',$maybeHeader) && in_array('department',$maybeHeader);
      if (!$hasHeader) rewind($h); else { /* we already consumed header row */ }

      while (($row = fgetcsv($h)) !== false) {
        if (count($row) < 2) { $skipped++; continue; }
        // map: name,email,phone,department
        $name = trim($row[0] ?? '');
        $email= trim($row[1] ?? '');
        $phone= trim($row[2] ?? '');
        $deptn= trim($row[3] ?? '');

        if ($name==='') { $skipped++; continue; }

        // get/create department
        $depId = $deptn ? upsert_department($deptn, $conn) : null;

        // dedupe by email or phone
        $chk = $conn->prepare("SELECT id FROM employees WHERE (email<>'' AND email=?) OR (phone<>'' AND phone=?) LIMIT 1");
        $chk->bind_param("ss", $email, $phone);
        $chk->execute();
        if ($chk->get_result()->fetch_assoc()) { $skipped++; continue; }

        $ins = $conn->prepare("INSERT INTO employees (name,email,phone,department_id) VALUES (?,?,?,?)");
        $did = $depId ?: null;
        $ins->bind_param("sssi", $name,$email,$phone,$did);
        $ins->execute();
        $added++;
      }
      fclose($h);
      $msg = "CSV upload complete: <strong>$added added</strong>, <strong>$skipped skipped</strong>.";
    } else {
      $err = "Could not read uploaded file.";
    }
  } else {
    $err = "Please choose a CSV file.";
  }
}

/** ADD/EDIT single employee */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['form']) && $_POST['form']==='save') {
  $id   = (int)($_POST['id'] ?? 0);
  $name = trim($_POST['name'] ?? '');
  $email= trim($_POST['email'] ?? '');
  $phone= trim($_POST['phone'] ?? '');
  $dep  = (int)($_POST['department_id'] ?? 0);
  if ($name !== '') {
    if ($id>0) {
      $stmt=$conn->prepare("UPDATE employees SET name=?,email=?,phone=?,department_id=? WHERE id=?");
      $stmt->bind_param("sssii",$name,$email,$phone,$dep,$id);
      $stmt->execute();
      $msg="Employee updated.";
    } else {
      $stmt=$conn->prepare("INSERT INTO employees(name,email,phone,department_id) VALUES(?,?,?,?)");
      $stmt->bind_param("sssi",$name,$email,$phone,$dep);
      $stmt->execute(); $msg="Employee added.";
    }
  }
}
if (($_GET['action']??'')==='delete' && isset($_GET['id'])) {
  $conn->query("DELETE FROM employees WHERE id=".(int)$_GET['id']); $msg="Employee deleted.";
}

$deps = $conn->query("SELECT id,name FROM departments ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$res  = $conn->query("SELECT e.id,e.name,e.email,e.phone,d.name AS department
                      FROM employees e LEFT JOIN departments d ON d.id=e.department_id
                      ORDER BY e.name");
?>
<h3 class="mb-3">Employees / Hosts</h3>
<?php if($msg): ?><div class="alert alert-success"><?php echo $msg; ?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?php echo $err; ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-3 mb-3">
      <h5 class="mb-3">Add / Edit Employee</h5>
      <form method="POST">
        <input type="hidden" name="form" value="save">
        <input type="hidden" name="id" id="emp_id">
        <div class="mb-2">
          <label class="form-label">Full Name</label>
          <input class="form-control" name="name" id="emp_name" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Email</label>
          <input type="email" class="form-control" name="email" id="emp_email">
        </div>
        <div class="mb-2">
          <label class="form-label">Phone</label>
          <input class="form-control" name="phone" id="emp_phone">
        </div>
        <div class="mb-3">
          <label class="form-label">Department</label>
          <select class="form-select" name="department_id" id="emp_dep">
            <option value="0">-- None --</option>
            <?php foreach($deps as $d): ?>
              <option value="<?php echo $d['id']; ?>"><?php echo htmlspecialchars($d['name']); ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="d-flex gap-2">
          <button class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" onclick="clearEmp()">Clear</button>
        </div>
      </form>
    </div>

    <div class="card p-3">
      <h5 class="mb-2">Bulk Upload (CSV)</h5>
      <p class="text-muted small mb-2">CSV columns: <code>name,email,phone,department</code></p>
      <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="csv_upload" value="1">
        <div class="d-flex gap-2">
          <input type="file" name="csv" accept=".csv" class="form-control" required>
          <button class="btn btn-outline-primary">Upload</button>
        </div>
      </form>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-0">
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light">
            <tr><th>#</th><th>Name</th><th>Email</th><th>Phone</th><th>Department</th><th>Action</th></tr>
          </thead>
          <tbody>
          <?php $i=1; while($r=$res->fetch_assoc()): ?>
            <tr>
              <td><?php echo $i++; ?></td>
              <td><?php echo htmlspecialchars($r['name']); ?></td>
              <td><?php echo htmlspecialchars($r['email']); ?></td>
              <td><?php echo htmlspecialchars($r['phone']); ?></td>
              <td><?php echo htmlspecialchars($r['department'] ?? '-'); ?></td>
              <td class="text-nowrap">
                <button class="btn btn-sm btn-outline-primary"
                        onclick="editEmp(<?php echo $r['id']; ?>,
                          '<?php echo htmlspecialchars($r['name'],ENT_QUOTES); ?>',
                          '<?php echo htmlspecialchars($r['email'],ENT_QUOTES); ?>',
                          '<?php echo htmlspecialchars($r['phone'],ENT_QUOTES); ?>',
                          '<?php echo (int)$r['department_id'] ?? 0; ?>')">Edit</button>
                <a class="btn btn-sm btn-outline-danger"
                   href="?action=delete&id=<?php echo $r['id']; ?>"
                   onclick="return confirm('Delete this employee?')">Delete</a>
              </td>
            </tr>
          <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
function editEmp(id,name,email,phone,dep){
  document.getElementById('emp_id').value=id;
  document.getElementById('emp_name').value=name;
  document.getElementById('emp_email').value=email;
  document.getElementById('emp_phone').value=phone;
  if (document.getElementById('emp_dep')) document.getElementById('emp_dep').value=dep||0;
  window.scrollTo({top:0, behavior:'smooth'});
}
function clearEmp(){
  document.getElementById('emp_id').value='';
  document.getElementById('emp_name').value='';
  document.getElementById('emp_email').value='';
  document.getElementById('emp_phone').value='';
  if (document.getElementById('emp_dep')) document.getElementById('emp_dep').value=0;
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>
