<?php 
include "../includes/header.php"; 
require_once "../config/db.php"; 
require_once "../includes/functions.php"; 

if ($_SESSION['role'] !== 'admin') {
  echo "<div class='alert alert-danger'>Access Denied!</div>";
  include "../includes/footer.php";
  exit();
}
?>
<h3 class="mb-4">Visitors</h3>
<div class="table-responsive">
<table class="table table-bordered table-striped">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Name</th>
      <th>Email</th>
      <th>Phone</th>
      <th>Host</th>
      <th>Purpose</th>
      <th>Status</th>
      <th>Check-in</th>
      <th>Check-out</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $sql = "SELECT v.*, h.name AS host_name FROM visitors v LEFT JOIN hosts h ON v.host_id=h.id ORDER BY v.id DESC";
    $result = $conn->query($sql);
    $count = 1;
    while ($row = $result->fetch_assoc()):
    ?>
    <tr>
      <td><?php echo $count++; ?></td>
      <td><?php echo htmlspecialchars($row['name']); ?></td>
      <td><?php echo htmlspecialchars($row['email']); ?></td>
      <td><?php echo htmlspecialchars($row['phone']); ?></td>
      <td><?php echo htmlspecialchars($row['host_name']); ?></td>
      <td><?php echo htmlspecialchars($row['purpose']); ?></td>
      <td><?php echo $row['status']; ?></td>
      <td><?php echo $row['checkin_time']; ?></td>
      <td><?php echo $row['checkout_time']; ?></td>
    </tr>
    <?php endwhile; ?>
  </tbody>
</table>
</div>
<?php include "../includes/footer.php"; ?>
