<?php
// app/controllers/dashboardController.php

// Ensure user has the right to view dashboard
if (!user_has_permission('view_dashboard')) {
    http_response_code(403);
    include __DIR__ . '/../views/403.php';
    exit;
}

// Create model instance and fetch stats
$dashboardModel = new Dashboard($conn);
$stats = $dashboardModel->getStats();

// Optional page title for header
$page_title = "Dashboard";

// Load layout + view
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/dashboard.php';
include __DIR__ . '/../views/layouts/footer.php';
