<?php
// app/controllers/inductionController.php

$page_title = "Visitor Induction";

$visitorModel   = new Visitor($conn);
$departmentModel = new Department($conn);

$success = "";
$error   = "";

// Handle Induction Form Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name          = trim($_POST['name']);
    $phone         = trim($_POST['phone']);
    $email         = trim($_POST['email']);
    $company       = trim($_POST['company']);
    $department_id = (int)$_POST['department_id'];

    if ($name === "" || $phone === "" || !$department_id) {
        $error = "Name, phone, and department are required.";
    } else {

        $data = [
            'name'               => $name,
            'phone'              => $phone,
            'email'              => $email,
            'company'            => $company,
            'department_id'      => $department_id,
            'induction_datetime' => date('Y-m-d H:i:s'),
            'status'             => 'inducted', // if you added this to ENUM
        ];

        $newVisitorId = $visitorModel->createInduction($data);

        if ($newVisitorId) {
            // Option 1: stay on page and show success
            $success = "Visitor inducted successfully. You can now proceed to check-in.";

            // Option 2: auto-redirect to check-in with prefill:
            // header("Location: index.php?page=visitor-checkin&returning=".$newVisitorId);
            // exit;

        } else {
            $error = "Unable to save induction. Please try again.";
        }
    }
}

// Load departments for dropdown
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name ASC");

// Load recent induction records
$inductions  = $visitorModel->getRecentInductions();

// Layout
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/layouts/sidebar.php';
include __DIR__ . '/../views/induction.php';
include __DIR__ . '/../views/layouts/footer.php';