<?php
// app/controllers/returning-visitorController.php

require_permission('returning_manage');   // RBAC

$visitorModel = new Visitor($conn);

$search = trim($_GET['q'] ?? '');
$results = null;

if ($search !== '') {
    // Search by name / phone / tag
    $like = '%' . $search . '%';

    $stmt = $conn->prepare("
        SELECT v.id,
               v.name,
               v.phone,
               v.company,
               v.tag_number,
               v.status,
               v.checkin_datetime
        FROM visitors v
        WHERE (
              v.name       LIKE ?
           OR v.phone      LIKE ?
           OR v.tag_number LIKE ?
        )
        ORDER BY v.checkin_datetime DESC
        LIMIT 50
    ");
    $stmt->bind_param('sss', $like, $like, $like);
    $stmt->execute();
    $results = $stmt->get_result();
    $stmt->close();
} else {
    // Show last 20 visitors
    $results = $conn->query("
        SELECT v.id,
               v.name,
               v.phone,
               v.company,
               v.tag_number,
               v.status,
               v.checkin_datetime
        FROM visitors v
        ORDER BY v.checkin_datetime DESC, v.created_at DESC
        LIMIT 20
    ");
}

$page_title = "Returning Visitor";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/returning-visitor.php';
include __DIR__ . '/../views/layouts/footer.php';