<?php

require_permission('manage_users'); // or manage_roles for finer control

$roleModel = new Role($conn);
$permModel = new Permission($conn);

$role_id = intval($_GET['id']);
$role = $roleModel->find($role_id);

if (!$role) {
    die("Role not found.");
}

// Fetch all permissions
$allPermissions = $permModel->all();

// Fetch assigned permissions
$assigned = [];
$result = $roleModel->getAssignedPermissions($role_id);

while ($row = $result->fetch_assoc()) {
    $assigned[] = $row['id'];
}

$success = "";
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name']);
    $slug = trim($_POST['slug']);
    $permissions = $_POST['permissions'] ?? [];

    // update role info
    $roleModel->update($role_id, $name, $slug);

    // delete old permissions
    $conn->query("DELETE FROM role_permissions WHERE role_id = $role_id");

    // insert new permissions
    foreach ($permissions as $perm_id) {
        $stmt = $conn->prepare("INSERT INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
        $stmt->bind_param("ii", $role_id, $perm_id);
        $stmt->execute();
    }

    $success = "Role updated successfully.";
}

$page_title = "Edit Role";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/roles-edit.php';
include __DIR__ . '/../views/layouts/footer.php';