<?php

require_permission('manage_users');

$roleModel = new Role($conn);
$deptModel = new Department($conn);

$roles = $roleModel->all();
$departments = $deptModel->all();

$error = "";
$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $passwordHash = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role_id = intval($_POST['role_id']);
    $department_id = intval($_POST['department_id']);

    $userModel = new User($conn);

    if ($userModel->create($username, $email, $passwordHash, $role_id, $department_id)) {
        header("Location: index.php?page=users&created=1");
        exit;
    } else {
        $error = "Unable to create user.";
    }
}

$page_title = "Create User";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/users-create.php';
include __DIR__ . '/../views/layouts/footer.php';