<?php

require_permission('manage_users');

$roleModel = new Role($conn);
$deptModel = new Department($conn);
$userModel = new User($conn);

$roles = $roleModel->all();
$departments = $deptModel->all();

$id = intval($_GET['id']);
$user = $userModel->find($id);

if (!$user) {
    die("User not found.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email = trim($_POST['email']);
    $role_id = intval($_POST['role_id']);
    $department_id = intval($_POST['department_id']);

    $userModel->update($id, $email, $role_id, $department_id);

    header("Location: index.php?page=users&updated=1");
    exit;
}

$page_title = "Edit User";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/users-edit.php';
include __DIR__ . '/../views/layouts/footer.php';