<?php
// app/controllers/visitor-checkinController.php

require_permission('checkin_visitor');

$visitorModel = new Visitor($conn);

$returningData = null;
if (isset($_GET['returning']) && is_numeric($_GET['returning'])) {
    $returningData = $visitorModel->find((int)$_GET['returning']);
}

$hosts = $conn->query("
    SELECT id, name
    FROM employees
    ORDER BY name ASC
");

$departments = $conn->query("
    SELECT id, name
    FROM departments
    ORDER BY name ASC
");

$defaultDate = date("Y-m-d");
$defaultTime = date("H:i");

$success = "";
$error   = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Photo
    $photoPath = null;
    if (!empty($_FILES['photo']['name'])) {
        $photoName = time() . "_" . basename($_FILES['photo']['name']);
        $photoPath = "uploads/photos/" . $photoName;
        @move_uploaded_file($_FILES['photo']['tmp_name'], $photoPath);
    }

    // Attachment
    $attachmentPath = null;
    if (!empty($_FILES['attachment']['name'])) {
        $attName = time() . "_" . basename($_FILES['attachment']['name']);
        $attachmentPath = "uploads/attachments/" . $attName;
        @move_uploaded_file($_FILES['attachment']['tmp_name'], $attachmentPath);
    }

    $data = [
        'name'           => $_POST['name'],
        'phone'          => $_POST['phone'],
        'email'          => $_POST['email'],
        'company'        => $_POST['company'],
        'gender'         => $_POST['gender'],
        'address'        => $_POST['address'],
        'purpose'        => $_POST['purpose'],
        'items_declared' => $_POST['items_declared'],
        'tag_number'     => $_POST['tag_number'],
        'host_id'        => (int)$_POST['host_id'],
        'department_id'  => (int)$_POST['department_id'],
        'photo'          => $photoPath,
        'attachment'     => $attachmentPath,
        'checkin_date'   => $_POST['checkin_date'],
        'checkin_time'   => $_POST['checkin_time'],
    ];

    $newVisitorId = $visitorModel->create($data);

    if ($newVisitorId) {
        // ✅ mark this record as checked-in
        $visitorModel->updateStatus($newVisitorId, 'checked_in');

        // QR
        $qrPath = generate_visitor_qr($newVisitorId);
        $visitorModel->saveQrPath($newVisitorId, $qrPath);

        header("Location: index.php?page=visitor-view&id=" . $newVisitorId);
        exit;
    } else {
        $error = "Something went wrong during check-in.";
    }
}

$page_title = "Visitor Check-In";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/visitor-checkin.php';
include __DIR__ . '/../views/layouts/footer.php';