<?php
// app/controllers/visitor-editController.php

if (!user_has_permission('visitor_edit')) {
    http_response_code(403);
    include __DIR__ . '/../views/403.php';
    exit;
}

// Get visitor ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$visitorModel   = new Visitor($conn);
$visitor        = $visitorModel->find($id);

if (!$visitor) {
    http_response_code(404);
    include __DIR__ . '/../views/404.php';
    exit;
}

// Load hosts & departments for dropdowns
$hosts = $conn->query("SELECT id, name FROM hosts ORDER BY name ASC");
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name ASC");

// Handle form submission
$success = "";
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = [
        'name'           => $_POST['name'],
        'phone'          => $_POST['phone'],
        'email'          => $_POST['email'],
        'company'        => $_POST['company'],
        'gender'         => $_POST['gender'],
        'address'        => $_POST['address'],
        'purpose'        => $_POST['purpose'],
        'items_declared' => $_POST['items_declared'],
        'tag_number'     => $_POST['tag_number'],
        'host_id'        => (int)$_POST['host_id'],
        'department_id'  => (int)$_POST['department_id'],
    ];

    if ($visitorModel->update($id, $data)) {
        $success = "Visitor updated successfully.";
        $visitor = $visitorModel->find($id); // refresh data
    } else {
        $error = "Something went wrong while updating.";
    }
}

$page_title = "Edit Visitor";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/visitor-edit.php';
include __DIR__ . '/../views/layouts/footer.php';