<?php
// app/controllers/visitor-newController.php

if (!user_has_permission('expected_manage')) {
    http_response_code(403);
    include __DIR__ . '/../views/403.php';
    exit;
}

$visitorModel = new Visitor($conn);

// Load dropdowns
$hosts       = $conn->query("SELECT id, name FROM hosts ORDER BY name ASC");
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name ASC");

$success = "";
$error   = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = [
        'name'           => $_POST['name'],
        'phone'          => $_POST['phone'],
        'email'          => $_POST['email'],
        'company'        => $_POST['company'],
        'gender'         => $_POST['gender'],
        'address'        => $_POST['address'],
        'purpose'        => $_POST['purpose'],
        'items_declared' => $_POST['items_declared'],
        'tag_number'     => $_POST['tag_number'],
        'host_id'        => (int) $_POST['host_id'],
        'department_id'  => (int) $_POST['department_id'],
    ];

    $visitorId = $visitorModel->createExpected($data);

    if ($visitorId) {

        // Generate QR
        $qrPath = generate_visitor_qr($visitorId);
        $visitorModel->saveQrPath($visitorId, $qrPath);

        header("Location: index.php?page=visitor-view&id=" . $visitorId . "&expected=1");
        exit;
    } else {
        $error = "Unable to create expected visitor.";
    }
}

$page_title = "New Visitor";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/visitor-new.php';
include __DIR__ . '/../views/layouts/footer.php';