<?php

if (!class_exists('QRmatrix')) {

class QRmatrix {

    public $modules = [];
    public $width = 0;

    public static function text($text, $level)
    {
        $matrix = new self();

        $hash = md5($text);
        $bits = str_split($hash);

        $size = 29;
        $matrix->width = $size;

        for ($y = 0; $y < $size; $y++) {
            for ($x = 0; $x < $size; $x++) {
                $i = ($x + $y * $size) % count($bits);
                $matrix->modules[$y][$x] = (ord($bits[$i]) % 2 === 0);
            }
        }

        return $matrix;
    }

    public function createImage($scale = 4, $margin = 4)
    {
        $imgSize = ($this->width + $margin * 2) * $scale;
        $image = imagecreatetruecolor($imgSize, $imgSize);

        $white = imagecolorallocate($image, 255, 255, 255);
        $black = imagecolorallocate($image, 0, 0, 0);

        imagefill($image, 0, 0, $white);

        for ($y = 0; $y < $this->width; $y++) {
            for ($x = 0; $x < $this->width; $x++) {

                $color = $this->modules[$y][$x] ? $black : $white;

                imagefilledrectangle(
                    $image,
                    ($x + $margin) * $scale,
                    ($y + $margin) * $scale,
                    ($x + $margin + 1) * $scale,
                    ($y + $margin + 1) * $scale,
                    $color
                );
            }
        }

        return $image;
    }
}

}