<?php
// app/views/dashboard.php
$status = $stats['status_counts'] ?? [];
$ind    = $stats['induction_counts'] ?? [];
?>

<div class="row mb-4">
  <div class="col-12">
    <h2 class="mb-0">Dashboard</h2>
    <p class="text-muted">Visitor & induction overview</p>
  </div>
</div>

<div class="row g-3 mb-4">
  <div class="col-sm-6 col-lg-3">
    <div class="card shadow-sm border-0">
      <div class="card-body">
        <h6 class="text-muted text-uppercase">Total Visitors</h6>
        <h3><?= (int)$stats['total_visitors'] ?></h3>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card shadow-sm border-0">
      <div class="card-body">
        <h6 class="text-muted text-uppercase">Visitors Today</h6>
        <h3><?= (int)$stats['visitors_today'] ?></h3>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card shadow-sm border-0">
      <div class="card-body">
        <h6 class="text-muted text-uppercase">Checked In</h6>
        <h3><?= (int)($status['checked_in'] ?? 0) ?></h3>
      </div>
    </div>
  </div>

  <div class="col-sm-6 col-lg-3">
    <div class="card shadow-sm border-0">
      <div class="card-body">
        <h6 class="text-muted text-uppercase">Overstays</h6>
        <h3><?= (int)$stats['overstays'] ?></h3>
      </div>
    </div>
  </div>
</div>

<div class="row g-3">
  <div class="col-lg-6">
    <div class="card shadow-sm border-0 h-100">
      <div class="card-header bg-white border-0">
        <strong>Visitor Status Breakdown</strong>
      </div>
      <div class="card-body">
        <ul class="list-group list-group-flush small">
          <li class="list-group-item d-flex justify-content-between">
            <span>Expected</span>
            <span class="fw-semibold"><?= (int)($status['expected'] ?? 0) ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span>Checked In</span>
            <span class="fw-semibold"><?= (int)($status['checked_in'] ?? 0) ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span>Checked Out</span>
            <span class="fw-semibold"><?= (int)($status['checked_out'] ?? 0) ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span>Returning</span>
            <span class="fw-semibold"><?= (int)($status['returning'] ?? 0) ?></span>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <div class="col-lg-6">
    <div class="card shadow-sm border-0 h-100">
      <div class="card-header bg-white border-0">
        <strong>Induction Overview</strong>
      </div>
      <div class="card-body">
        <ul class="list-group list-group-flush small">
          <li class="list-group-item d-flex justify-content-between">
            <span>Pending Induction</span>
            <span class="fw-semibold"><?= (int)($ind['Pending'] ?? 0) ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span>Inducted</span>
            <span class="fw-semibold"><?= (int)($ind['Inducted'] ?? 0) ?></span>
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>