<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= htmlspecialchars($page_title ?? setting('company_name', 'Visitor Gate Pass')) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    /* GLOBAL LAYOUT */
    html, body {
        height: 100%;
        margin: 0;
    }

    body {
        background:#f3f5f9;
        display: flex;
        flex-direction: column;
    }

    .main-wrapper {
        display: flex;
        flex: 1; /* allows footer to stay at bottom */
    }

    /* SIDEBAR */
    .sidebar {
        width:260px;
        height:100vh;
        position:fixed;
        overflow-y:auto;
        background:#fff;
    }

    .sidebar .nav-link {
        padding:10px 20px;
        color:#333;
        transition:0.15s;
        border-radius:6px;
    }

    .sidebar .nav-link:hover {
        background:#e8f0ff !important;
        color:#003399 !important;
    }

    .sidebar .nav-link.active {
        background:#0d6efd !important;
        color:#fff !important;
    }

    .menu-section {
        font-size:11px;
        color:#888;
        padding:8px 20px;
        margin-top:20px;
        text-transform:uppercase;
    }

    /* TOPBAR */
    .topbar {
        position: fixed;
        left: 260px;
        right: 0;
        top: 0;
        height: 60px;
        background: white;
        border-bottom: 1px solid #e6e6e6;
        z-index: 2000;
    }

    /* MAIN CONTENT */
    .content-area {
        margin-left:260px;
        margin-top:60px;
        flex:1;
        padding:40px;
    }
/* FOOTER FIX — aligns with sidebar & sticks to bottom */
.app-footer {
    margin-left: 260px;     /* align perfectly with sidebar */
    background: white;
    border-top: 1px solid #e6e6e6;
    padding: 12px 30px;
    height: 50px;

    display: flex;
    align-items: center;
    justify-content: space-between;
}

.footer-inner {
    width: 100%;
    max-width: 100%;
}

  </style>
</head>

<body>

<div class="main-wrapper">

<?php include __DIR__ . '/sidebar.php'; ?>

<!-- TOP NAVIGATION BAR -->
<nav class="topbar d-flex align-items-center justify-content-between px-4">

    <!-- LEFT BRANDING -->
    <span class="fw-semibold fs-5">
        <?= htmlspecialchars(setting('company_name', 'Visitor Gate Pass')) ?>
    </span>

    <!-- RIGHT SIDE -->
    <div class="d-flex align-items-center gap-4">

        <!-- CHECK-OUT BUTTON -->
        <a href="index.php?page=checkout" class="btn btn-outline-danger btn-sm">
            <i class="bi bi-box-arrow-right"></i> Check-Out
        </a>

        <!-- USER DROPDOWN -->
        <div class="dropdown">
            <button class="btn btn-light rounded-pill px-3 dropdown-toggle" data-bs-toggle="dropdown">
                <i class="bi bi-person-circle me-1"></i>
                <?= htmlspecialchars($_SESSION['username'] ?? 'Account') ?>
            </button>

            <ul class="dropdown-menu dropdown-menu-end shadow">
                <li class="dropdown-header small text-muted">
                    Logged in as <strong><?= htmlspecialchars($_SESSION['username'] ?? '') ?></strong>
                </li>

                <li>
                    <a class="dropdown-item" href="index.php?page=change-password">
                        <i class="bi bi-key me-2"></i> Change Password
                    </a>
                </li>

                <li><hr class="dropdown-divider"></li>

                <li>
                    <a class="dropdown-item text-danger" href="index.php?page=logout">
                        <i class="bi bi-box-arrow-right me-2"></i> Logout
                    </a>
                </li>
            </ul>
        </div>

    </div>
</nav>

<!-- MAIN CONTENT AREA -->
<div class="content-area">