<?php
/* -------------------------------------------------------------
   SAFE HELPERS (Prevent Function Redeclare Errors)
--------------------------------------------------------------*/

if (!function_exists('e')) {
    function e($v) {
        return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
    }
}

$currentStatus = $status ?? 'all';

if (!function_exists('status_badge_class')) {
    function status_badge_class($s) {
        return match ($s) {
            'checked_in'   => 'bg-success',
            'checked_out'  => 'bg-secondary',
            'expected'     => 'bg-warning text-dark',
            'inducted'     => 'bg-info text-dark',
            'returning'    => 'bg-primary',
            default        => 'bg-dark',
        };
    }
}

if (!function_exists('status_label')) {
    function status_label($s) {
        return ucfirst(str_replace('_', ' ', $s ?: 'unknown'));
    }
}
?>

<!-- PAGE TITLE -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Visitor Reports</h2>
</div>

<!-- STATUS TABS -->
<ul class="nav nav-tabs mb-3">
    <?php
    $tabs = [
        'all'         => ['icon' => 'bi-list-ul',          'label' => 'All'],
        'expected'    => ['icon' => 'bi-clock-history',    'label' => 'Expected'],
        'inducted'    => ['icon' => 'bi-shield-check',     'label' => 'Inducted'],
        'checked_in'  => ['icon' => 'bi-box-arrow-in-right','label' => 'Checked-In'],
        'checked_out' => ['icon' => 'bi-box-arrow-right',  'label' => 'Checked-Out'],
        'returning'   => ['icon' => 'bi-arrow-repeat',     'label' => 'Returning'],
    ];

    foreach ($tabs as $key => $tab):
        $active = ($currentStatus === $key) ? 'active' : '';
        ?>
        <li class="nav-item">
            <a class="nav-link <?= $active ?>"
               href="index.php?page=reports&status=<?= $key ?>">
               <i class="bi <?= $tab['icon'] ?> me-1"></i> <?= $tab['label'] ?>
            </a>
        </li>
    <?php endforeach; ?>
</ul>

<!-- FILTERS CARD -->
<div class="card shadow-sm mb-3">
    <div class="card-body">
        <form class="row g-2" method="get" action="index.php">

            <input type="hidden" name="page" value="reports">
            <input type="hidden" name="status" value="<?= e($currentStatus) ?>">

            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start" class="form-control"
                       value="<?= e($_GET['start'] ?? '') ?>">
            </div>

            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end" class="form-control"
                       value="<?= e($_GET['end'] ?? '') ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">Search</label>
                <input type="text"
                       name="q"
                       class="form-control"
                       placeholder="Name, Phone, Tag, Company"
                       value="<?= e($_GET['q'] ?? '') ?>">
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-primary w-100">
                    <i class="bi bi-search"></i> Apply
                </button>
            </div>
        </form>
    </div>
</div>

<!-- TABLE CARD -->
<div class="card shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0 table-hover align-middle">
                <thead class="table-light">
                <tr>
                    <th>Photo</th>
                    <th>Visitor</th>
                    <th>Phone</th>
                    <th>Company</th>
                    <th>Host</th>
                    <th>Department</th>
                    <th>Status</th>
                    <th>Check-In</th>
                    <th>Check-Out</th>
                    <th>Tag</th>
                    <th style="width:170px;">Actions</th>
                </tr>
                </thead>

                <tbody>
                <?php if ($records && $records->num_rows > 0): ?>

                    <?php while ($v = $records->fetch_assoc()): ?>

                        <?php
                        // Prepare fields
                        $checkinDT = trim(($v['checkin_date'] ?? '') . ' ' . ($v['checkin_time'] ?? ''));
                        $checkinDT = $checkinDT ?: '—';

                        $checkoutDT = $v['checkout_time'] ?: '—';
                        $gender     = $v['gender'] ?: '—';
                        ?>

                        <tr>
                            <!-- PHOTO -->
                            <td>
                                <?php if (!empty($v['photo'])): ?>
                                    <img src="<?= e($v['photo']) ?>"
                                         onclick="showPhotoModal('<?= e($v['photo']) ?>')"
                                         style="width:45px; height:45px; object-fit:cover; border-radius:50%; cursor:pointer;">
                                <?php else: ?>
                                    <i class="bi bi-person-circle fs-3 text-secondary"></i>
                                <?php endif; ?>
                            </td>

                            <!-- VISITOR -->
                            <td>
                                <strong><?= e($v['name']) ?></strong><br>
                                <small class="text-muted">Gender: <?= e($gender) ?></small>
                            </td>

                            <td><?= e($v['phone']) ?></td>
                            <td><?= e($v['company'] ?: '—') ?></td>
                            <td><?= e($v['host_name'] ?: '—') ?></td>
                            <td><?= e($v['department_name'] ?: '—') ?></td>

                            <!-- STATUS BADGE -->
                            <td>
                                <span class="badge <?= status_badge_class($v['status']) ?>">
                                    <?= e(status_label($v['status'])) ?>
                                </span>
                            </td>

                            <td><?= e($checkinDT) ?></td>
                            <td><?= e($checkoutDT) ?></td>
                            <td><?= e($v['tag_number'] ?: '—') ?></td>

                            <!-- ACTIONS -->
                            <td>
                                <div class="btn-group btn-group-sm">

                                    <a href="index.php?page=visitor-view&id=<?= (int)$v['id'] ?>"
                                       class="btn btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>

                                    <a href="index.php?page=visitor-print-badge&id=<?= (int)$v['id'] ?>"
                                       class="btn btn-outline-secondary" title="Print Badge">
                                        <i class="bi bi-printer"></i>
                                    </a>

                                    <?php if ($v['status'] === 'checked_in'): ?>
                                        <a href="index.php?page=visitor-checkout&id=<?= (int)$v['id'] ?>"
                                           class="btn btn-outline-success" title="Check-Out">
                                            <i class="bi bi-box-arrow-right"></i>
                                        </a>
                                    <?php endif; ?>

                                </div>
                            </td>
                        </tr>

                    <?php endwhile; ?>

                <?php else: ?>
                    <tr>
                        <td colspan="11" class="text-center py-4">
                            No records found.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

            <!-- PAGINATION -->
            <div class="d-flex justify-content-between align-items-center p-3">

                <!-- Limit selector -->
                <form method="get" class="d-flex align-items-center">
                    <input type="hidden" name="page" value="reports">
                    <input type="hidden" name="status" value="<?= e($currentStatus) ?>">
                    <input type="hidden" name="start" value="<?= e($_GET['start'] ?? '') ?>">
                    <input type="hidden" name="end" value="<?= e($_GET['end'] ?? '') ?>">
                    <input type="hidden" name="q" value="<?= e($_GET['q'] ?? '') ?>">

                    <label class="me-2">Show</label>
                    <select name="limit" class="form-select form-select-sm" onchange="this.form.submit()">
                        <?php foreach ([10,25,50,100] as $l): ?>
                            <option value="<?= $l ?>" <?= ($l == ($limit ?? 10)) ? 'selected' : '' ?>>
                                <?= $l ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <span class="ms-2">entries</span>
                </form>

                <!-- Page numbers -->
                <nav>
                    <ul class="pagination pagination-sm mb-0">
                        <li class="page-item <?= ($page <= 1 ? 'disabled' : '') ?>">
                            <a class="page-link" href="index.php?page=reports&status=<?= $currentStatus ?>&p=<?= $page-1 ?>&limit=<?= $limit ?>">Previous</a>
                        </li>

                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= ($i == $page ? 'active' : '') ?>">
                                <a class="page-link" href="index.php?page=reports&status=<?= $currentStatus ?>&p=<?= $i ?>&limit=<?= $limit ?>">
                                    <?= $i ?>
                                </a>
                            </li>
                        <?php endfor; ?>

                        <li class="page-item <?= ($page >= $totalPages ? 'disabled' : '') ?>">
                            <a class="page-link" href="index.php?page=reports&status=<?= $currentStatus ?>&p=<?= $page+1 ?>&limit=<?= $limit ?>">Next</a>
                        </li>
                    </ul>
                </nav>

            </div>
        </div>
    </div>
</div>

<!-- PHOTO MODAL -->
<div class="modal fade" id="photoModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body p-0">
        <img id="photoPreview" src="" class="w-100" style="border-radius:6px;">
      </div>
    </div>
  </div>
</div>

<script>
function showPhotoModal(src) {
    document.getElementById('photoPreview').src = src;
    new bootstrap.Modal(document.getElementById('photoModal')).show();
}
</script>