<h2>System Settings</h2>
<p class="text-muted mb-4">Manage company details, email settings, and system preferences.</p>

<?php if (!empty($success)): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<!-- TABS -->
<ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">

    <li class="nav-item" role="presentation">
        <button class="nav-link active"
                id="tab-page-settings"
                data-bs-toggle="tab"
                data-bs-target="#page-settings"
                type="button"
                role="tab"
                aria-controls="page-settings"
                aria-selected="true">
            <i class="bi bi-gear-wide-connected me-1"></i> Page Settings
        </button>
    </li>

    <li class="nav-item" role="presentation">
        <button class="nav-link"
                id="tab-smtp-settings"
                data-bs-toggle="tab"
                data-bs-target="#smtp-settings"
                type="button"
                role="tab"
                aria-controls="smtp-settings"
                aria-selected="false">
            <i class="bi bi-envelope-gear-fill me-1"></i> SMTP Settings
        </button>
    </li>

    <li class="nav-item" role="presentation">
        <button class="nav-link"
                id="tab-general-settings"
                data-bs-toggle="tab"
                data-bs-target="#general-settings"
                type="button"
                role="tab"
                aria-controls="general-settings"
                aria-selected="false">
            <i class="bi bi-sliders me-1"></i> General Settings
        </button>
    </li>

</ul>


<div class="tab-content">

    <!-- PAGE SETTINGS TAB -->
    <div class="tab-pane fade show active" id="page-settings" role="tabpanel">
        <form method="post" action="index.php?page=settings&tab=page" enctype="multipart/form-data">

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white">
                <strong>Company Profile</strong>
            </div>
            <div class="card-body">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Company Name</label>
                        <input type="text" name="company_name" class="form-control"
                               value="<?= $settings['company_name'] ?>" required>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Phone</label>
                        <input type="text" name="company_phone" class="form-control"
                               value="<?= $settings['company_phone'] ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="company_email" class="form-control"
                               value="<?= $settings['company_email'] ?>">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Company Address</label>
                    <textarea name="company_address" class="form-control" rows="2"><?= $settings['company_address'] ?></textarea>
                </div>

                <div class="row align-items-center">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Logo Upload</label>
                        <input type="file" name="company_logo" class="form-control">
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label d-block">Current Logo</label>
                        <img src="<?= $settings['company_logo'] ?>" alt="Logo" style="max-height:60px;">
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label">Theme</label>
                        <select name="theme" class="form-select">
                            <option value="light" <?= $settings['theme']=='light'?'selected':'' ?>>Light</option>
                            <option value="dark"  <?= $settings['theme']=='dark'?'selected':'' ?>>Dark</option>
                        </select>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Footer Text</label>
                    <input type="text" name="footer_text" class="form-control"
                           value="<?= $settings['footer_text'] ?>">
                </div>

            </div>
        </div>

        <button class="btn btn-primary">Save Page Settings</button>
        </form>
    </div>
    <!-- END PAGE SETTINGS TAB -->

    <!-- SMTP SETTINGS TAB -->
    <div class="tab-pane fade" id="smtp-settings" role="tabpanel">
        <form method="post" action="index.php?page=settings&tab=smtp">

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white">
                <strong>Email / SMTP Settings</strong>
            </div>
            <div class="card-body">

                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">SMTP Host</label>
                        <input type="text" name="smtp_host" class="form-control"
                               value="<?= $settings['smtp_host'] ?>">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Port</label>
                        <input type="text" name="smtp_port" class="form-control"
                               value="<?= $settings['smtp_port'] ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Encryption</label>
                        <select name="smtp_encryption" class="form-select">
                            <option value="">None</option>
                            <option value="ssl" <?= $settings['smtp_encryption']=='ssl'?'selected':'' ?>>SSL</option>
                            <option value="tls" <?= $settings['smtp_encryption']=='tls'?'selected':'' ?>>TLS</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">SMTP Username</label>
                        <input type="text" name="smtp_username" class="form-control"
                               value="<?= $settings['smtp_username'] ?>">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">SMTP Password</label>
                        <input type="password" name="smtp_password" class="form-control"
                               value="<?= $settings['smtp_password'] ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">From Name</label>
                        <input type="text" name="smtp_from_name" class="form-control"
                               value="<?= $settings['smtp_from_name'] ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">From Email</label>
                        <input type="email" name="smtp_from_email" class="form-control"
                               value="<?= $settings['smtp_from_email'] ?>">
                    </div>
                </div>

            </div>
        </div>

        <button class="btn btn-primary">Save SMTP Settings</button>
        </form>
    </div>
    <!-- END SMTP SETTINGS TAB -->

    <!-- GENERAL SETTINGS TAB -->
    <div class="tab-pane fade" id="general-settings" role="tabpanel">
        <form method="post" action="index.php?page=settings&tab=general">

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-white">
                <strong>Visitor Rules & Alerts</strong>
            </div>

            <div class="card-body">

                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Overstay Limit (hours)</label>
                        <input type="number" name="overstay_limit" class="form-control"
                               value="<?= setting('overstay_limit', 2) ?>">
                    </div>

                    <div class="col-md-9 mb-3">
                        <label class="form-label">Overstay Alert Emails</label>
                        <input type="text" name="overstay_alert_emails" class="form-control"
                               value="<?= setting('overstay_alert_emails', '') ?>">
                        <small class="text-muted">Comma-separated list.</small>
                    </div>
                </div>

                <hr>

                <!-- NOTIFICATION RECIPIENTS -->
                <h5 class="mb-3">📧 Notification Recipients</h5>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label>Visitor Check-In Emails</label>
                        <input type="text" name="notify_checkin" class="form-control"
                               value="<?= setting('notify_checkin', '') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Induction Notification Emails</label>
                        <input type="text" name="notify_induction" class="form-control"
                               value="<?= setting('notify_induction', '') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Visitor Checkout Emails</label>
                        <input type="text" name="notify_checkout" class="form-control"
                               value="<?= setting('notify_checkout', '') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Expected Visitor Emails</label>
                        <input type="text" name="notify_expected" class="form-control"
                               value="<?= setting('notify_expected', '') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Returning Visitor Emails</label>
                        <input type="text" name="notify_returning" class="form-control"
                               value="<?= setting('notify_returning', '') ?>">
                    </div>
                </div>

            </div>
        </div>

        <button class="btn btn-primary">Save General Settings</button>
        </form>
    </div>
    <!-- END GENERAL TAB -->

</div>

</form>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>