<div class="row mb-4">
  <div class="col-12 d-flex justify-content-between">
    <h2>Add Expected Visitor</h2>
    <a href="index.php?page=visitors" class="btn btn-secondary">Back</a>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="post">

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Full Name</label>
          <input type="text" name="name" class="form-control" required>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Phone</label>
          <input type="text" name="phone" class="form-control" required>
        </div>
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control">
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Company</label>
          <input type="text" name="company" class="form-control">
        </div>
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Gender</label>
          <select name="gender" class="form-select">
            <option value="">-- Select --</option>
            <option value="Male">Male</option>
            <option value="Female">Female</option>
          </select>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Purpose of Visit</label>
          <input type="text" name="purpose" class="form-control">
        </div>
      </div>

      <div class="mb-3">
        <label class="form-label">Items Declared</label>
        <input type="text" name="items_declared" class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label">Tag Number</label>
        <input type="text" name="tag_number" class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label">Address</label>
        <textarea name="address" class="form-control"></textarea>
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Host</label>
          <select name="host_id" class="form-select" required>
            <option value="">-- Select Host --</option>
            <?php while($h = $hosts->fetch_assoc()): ?>
              <option value="<?= $h['id'] ?>"><?= htmlspecialchars($h['name']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="col-md-6 mb-3">
          <label class="form-label">Department</label>
          <select name="department_id" class="form-select" required>
            <option value="">-- Select Department --</option>
            <?php while($d = $departments->fetch_assoc()): ?>
              <option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['name']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
      </div>

      <button type="submit" class="btn btn-primary">Save Visitor</button>

    </form>

  </div>
</div>