(function () {
  // Sidebar toggle and active link highlighting
  const toggle = document.getElementById("sidebarToggle");
  const sidebar = document.getElementById("appSidebar");
  if (toggle && sidebar) {
    toggle.addEventListener("click", () =>
      sidebar.classList.toggle("show")
    );
  }

  const here = location.pathname.replace(/\/+$/, "");
  document.querySelectorAll(".sidebar .nav-link").forEach((a) => {
    try {
      const url = new URL(a.href);
      if (here.endsWith(url.pathname.replace(/\/+$/, "")))
        a.classList.add("active");
    } catch (e) {}
  });
})();

/* =========================================================
 * Visitor Check-Out (Tag Number Based)
 * =======================================================*/
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("checkoutForm");
  if (!form) return;

  form.addEventListener("submit", async (e) => {
    e.preventDefault();
    const btn = form.querySelector('button[type="submit"]');
    const tag = form.querySelector('input[name="tag_number"]').value.trim();

    if (!tag) {
      showToast("Please enter a visitor tag number.", "danger");
      return;
    }

    btn.disabled = true;
    btn.innerHTML =
      '<span class="spinner-border spinner-border-sm me-2"></span>Checking...';

    try {
      const res = await fetch("/shared/checkout_action_tag.php", {
        method: "POST",
        body: new FormData(form),
      });

      const data = await res.json();

      if (data.ok) {
        const now = new Date().toLocaleTimeString([], { hour: "2-digit", minute: "2-digit" });
        showToast(
          `${data.message || "Visitor checked out successfully."}<br><small class="text-light">at ${now}</small>`,
          "success"
        );
        form.reset();
        btn.disabled = true; // Prevent double-click
        setTimeout(() => location.reload(), 1200);
      } else if (data.error && data.error.includes("not currently checked in")) {
        // Ignore harmless duplicate warning
        showToast("Visitor already checked out.", "info");
      } else {
        showToast(data.error || "An error occurred during checkout.", "danger");
      }
    } catch (err) {
      showToast("Network error — please try again.", "warning");
    } finally {
      btn.disabled = false;
      btn.innerHTML =
        '<i class="bi bi-box-arrow-right me-2"></i>Check Out Visitor';
    }
  });
});

/* =========================================================
 * Toast Notification Function (Bootstrap 5)
 * =======================================================*/
function showToast(message, type = "info") {
  const toastContainer =
    document.getElementById("toastContainer") ||
    (() => {
      const div = document.createElement("div");
      div.id = "toastContainer";
      div.className = "position-fixed top-0 end-0 p-3";
      div.style.zIndex = "1100";
      document.body.appendChild(div);
      return div;
    })();

  const wrapper = document.createElement("div");
  wrapper.className = `toast align-items-center text-white bg-${type} border-0 show mb-2`;
  wrapper.role = "alert";
  wrapper.innerHTML = `
    <div class="d-flex">
      <div class="toast-body">${message}</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  `;

  toastContainer.appendChild(wrapper);
  setTimeout(() => wrapper.remove(), 4000);
}