<?php
session_start();

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/db.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/includes/functions.php';

if (!empty($_SESSION['user_id'])) {
    header('Location: /admin/dashboard.php');
    exit;
}

$logo = get_setting('company_logo');
$logo_src = $logo ? "/assets/{$logo}" : "/assets/logo.png";
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Visitor Gate Pass - Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body class="d-flex align-items-center" style="min-height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-5">
        <div class="login-card p-4 card">
          <div class="text-center mb-3">
            <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Logo" style="max-height:60px" onerror="this.style.display='none'">
            <h5 class="mt-2">Visitor Gate Pass</h5>
          </div>
          <form method="POST" action="do_login.php" class="row g-3">
            <div class="col-12"><label class="form-label">Username</label><input class="form-control" name="username" required></div>
            <div class="col-12"><label class="form-label">Password</label><input type="password" class="form-control" name="password" required></div>
            <div class="col-12 d-grid"><button class="btn btn-primary">Login</button></div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>