<?php
// Cron script for checking overstays

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

// 1. Get overstay limit in minutes
$limit = (int)setting_val('overstay_limit_minutes', 0);

if ($limit <= 0) {
    exit("No overstay limit configured.\n");
}

// 2. Fetch all active visitors (checked in and not checked out)
$sql = "SELECT v.*, 
        e.name AS host_name
        FROM visitors v
        LEFT JOIN employees e ON v.host_id = e.id
        WHERE v.status IN ('checked_in','returning')
        AND v.overstay_notified = 0";

$res = $conn->query($sql);

while ($row = $res->fetch_assoc()) {

    // How many minutes has the visitor stayed?
    $checkin_timestamp = strtotime($row['checkin_date'] . ' ' . $row['checkin_time']);
    $now = time();
    $minutes_stayed = ($now - $checkin_timestamp) / 60;

    if ($minutes_stayed >= $limit) {

        // 3. Send overstay notification
        notify_overstay($row, $limit);

        // 4. Mark visitor as notified
        $stmt = $conn->prepare("UPDATE visitors SET overstay_notified=1 WHERE id=?");
        $stmt->bind_param("i", $row['id']);
        $stmt->execute();
    }
}

echo "Overstay check completed.\n";