<?php
// Start session early & avoid header issues
if (session_status() === PHP_SESSION_NONE) {
    ob_start();
    session_start();
}

include_once __DIR__ . '/roles.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Visitor Gate Pass</title>
  <link rel="icon" href="/assets/favicon.ico" type="image/x-icon">

  <!-- Bootstrap / Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Custom -->
  <link rel="stylesheet" href="/assets/style.css">
  <script defer src="/assets/script.js"></script>
</head>

<body>
  <!-- Checkout modal must be global (to avoid freezing issues) -->
  <?php include __DIR__ . '/../shared/checkout_modal.php'; ?>

  <!-- Header Bar -->
  <div class="headerbar py-2 px-3 d-flex align-items-center justify-content-between border-bottom bg-white shadow-sm">
    <div class="d-flex align-items-center gap-2">
      <button class="btn btn-outline-primary btn-sm d-lg-none" id="sidebarToggle" aria-label="Toggle menu">
        <i class="bi bi-list"></i>
      </button>
      <img src="/assets/logo.png" alt="Logo" style="height:30px" onerror="this.style.display='none'">
      <span class="brand-title fw-bold">Visitor Gate Pass</span>
    </div>
    
    <div class="d-flex align-items-center gap-3">
      <!-- Check-Out Button -->
      <button type="button" class="btn btn-outline-danger btn-sm" data-bs-toggle="modal" data-bs-target="#checkoutModal">
        <i class="bi bi-box-arrow-right me-1"></i> Check-Out
      </button>

      <!-- Logged in user -->
      <span class="text-muted small d-none d-md-inline">
        <?php if (!empty($_SESSION['username'])): ?>
          <i class="bi bi-person-circle me-1"></i>
          <?php echo htmlspecialchars($_SESSION['username']); ?>
          <?php if (!empty($_SESSION['role'])): ?>
            <span class="text-muted">(<?php echo htmlspecialchars($_SESSION['role']); ?>)</span>
          <?php endif; ?>
        <?php endif; ?>
      </span>

      <!-- Account dropdown -->
      <div class="dropdown">
        <button class="btn btn-light btn-sm dropdown-toggle" data-bs-toggle="dropdown">Account</button>
        <ul class="dropdown-menu dropdown-menu-end shadow-sm">
          <li class="dropdown-item-text small text-muted">
            Logged in as <strong><?php echo htmlspecialchars($_SESSION['username'] ?? 'Guest'); ?></strong>
          </li>
          <li><hr class="dropdown-divider"></li>
          <li>
            <a class="dropdown-item text-danger" href="/auth/logout.php">
              <i class="bi bi-box-arrow-right me-2"></i>Logout
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <!-- Flash Messages -->
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
      <?php echo htmlspecialchars($_SESSION['flash_success']); ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['flash_success']); ?>
  <?php endif; ?>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
      <?php echo htmlspecialchars($_SESSION['flash_error']); ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['flash_error']); ?>
  <?php endif; ?>

  <!-- Main layout -->
  <div class="main-wrapper">
    <?php include __DIR__ . '/sidebar.php'; ?>
    <main class="content container-fluid pt-3 px-3">