<?php
// ========================
// SIDEBAR NAVIGATION
// ========================

// Current user role
$currentRole = $_SESSION['role'] ?? 'guest';

// Define role groups
$reception_roles = ['receptionist', 'it_officer', 'hse_officer', 'cso', 'pa'];
$admin_roles     = ['system_admin', 'admin_officer'];

// Determine base folder
$basePath = in_array($currentRole, $admin_roles) ? '/admin' : '/receptionist';

// Fallback function to avoid errors
if (!function_exists('can')) {
    function can($r) { return true; }
}
?>

<aside class="sidebar" id="appSidebar">
  <nav>
    <ul class="nav flex-column">

      <!-- Dashboard -->
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/dashboard.php">
          <i class="bi bi-speedometer2"></i> <span>Dashboard</span>
        </a>
      </li>

      <!-- OPERATIONS -->
      <div class="group-title">Operations</div>
      <li class="nav-item">
        <a class="nav-link" href="/admin/departments.php">
          <i class="bi bi-diagram-3"></i> <span>Departments</span>
        </a>
      </li>

      <li class="nav-item">
        <a class="nav-link" href="/admin/employees.php">
          <i class="bi bi-people"></i> <span>Employees</span>
        </a>
      </li>

      <!-- VISITORS -->
      <div class="group-title">Visitors</div>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/induction_register.php">
          <i class="bi bi-shield-check"></i> <span>Induction</span>
        </a>
      </li>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/visitors_add.php">
          <i class="bi bi-person-plus"></i> <span>Visitor Check-in</span>
        </a>
      </li>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/returning_visitors.php">
          <i class="bi bi-box-arrow-left"></i> <span>Returning Visitor</span>
        </a>
      </li>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/visitors_expected.php">
          <i class="bi bi-calendar-check"></i> <span>Expected Visitor</span>
        </a>
      </li>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $basePath; ?>/checkedin_visitors.php">
          <i class="bi bi-person-check me-2"></i> <span>Checked-In Visitors</span>
        </a>
      </li>

      <!-- REPORTS (Admins + Reception Roles) -->
      <?php if (in_array($currentRole, array_merge($admin_roles, $reception_roles))): ?>
        <div class="group-title">Reports</div>

        <li class="nav-item">
          <a class="nav-link" href="/reports/induction.php">
            <i class="bi bi-file-earmark-text"></i> <span>Induction Report</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/reports/visitors.php">
            <i class="bi bi-bar-chart"></i> <span>Visitor Report</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/reports/returning.php">
            <i class="bi bi-graph-up"></i> <span>Returning Visitor Report</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/reports/expected.php">
            <i class="bi bi-clipboard-data"></i> <span>Expected Visitor Report</span>
          </a>
        </li>
      <?php endif; ?>

      <!-- SETTINGS (Admins only) -->
      <?php if (in_array($currentRole, $admin_roles)): ?>
        <div class="group-title">Settings</div>

        <li class="nav-item">
          <a class="nav-link" href="/admin/users.php">
            <i class="bi bi-person-gear"></i> <span>Users</span>
          </a>
        </li>
        
        <li class="nav-item">
          <a class="nav-link" href="/admin/import_old_visitors.php">
            <i class="bi bi-database-add"></i> <span>Import Data</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/settings.php#page">
            <i class="bi bi-layout-text-sidebar-reverse"></i> <span>Page Setting</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/settings.php#smtp">
            <i class="bi bi-envelope-gear"></i> <span>SMTP Setting</span>
          </a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/settings.php#general">
            <i class="bi bi-sliders"></i> <span>General Setting</span>
          </a>
        </li>
      <?php endif; ?>

    </ul>
  </nav>
</aside>