<?php 
include "../includes/header.php"; 
require_once "../config/db.php"; 
require_once "../includes/functions.php"; 

if ($_SESSION['role'] !== 'receptionist') {
  echo "<div class='alert alert-danger'>Access Denied!</div>";
  include "../includes/footer.php";
  exit();
}

// Add or Check-in Visitor
if (isset($_POST['add_visitor'])) {
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $host_id = $_POST['host_id'];
    $purpose = $_POST['purpose'];
    $type = $_POST['type']; // expected or checkin

    $status = $type === 'expected' ? 'expected' : 'checked_in';
    $checkin_time = $status === 'checked_in' ? date('Y-m-d H:i:s') : NULL;

    $stmt = $conn->prepare("INSERT INTO visitors (name, phone, email, host_id, purpose, checkin_time, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssisss", $name, $phone, $email, $host_id, $purpose, $checkin_time, $status);
    $stmt->execute();

    if ($status === 'checked_in') {
        $result = $conn->query("SELECT email FROM hosts WHERE id=$host_id");
        if ($result && $row = $result->fetch_assoc()) {
            notify_host($name, $row['email'], $purpose);
        }
    }

    echo "<div class='alert alert-success'>Visitor record added successfully.</div>";
}

// Check-out Visitor
if (isset($_GET['checkout'])) {
    $id = intval($_GET['checkout']);
    $conn->query("UPDATE visitors SET status='checked_out', checkout_time=NOW() WHERE id=$id");

    $result = $conn->query("SELECT name, email FROM visitors WHERE id=$id");
    if ($row = $result->fetch_assoc()) {
        notify_visitor_checkout($row['email'], $row['name']);
    }

    echo "<div class='alert alert-info'>Visitor checked out successfully.</div>";
}

?>

<h3 class="mb-4">Visitor Management</h3>

<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addVisitorModal">Add / Check-in Visitor</button>

<div class="table-responsive">
<table class="table table-bordered table-striped">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Name</th>
      <th>Email</th>
      <th>Phone</th>
      <th>Host</th>
      <th>Purpose</th>
      <th>Status</th>
      <th>Check-in</th>
      <th>Check-out</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $sql = "SELECT v.*, h.name AS host_name FROM visitors v LEFT JOIN hosts h ON v.host_id=h.id ORDER BY v.id DESC";
    $result = $conn->query($sql);
    $count = 1;
    while ($row = $result->fetch_assoc()):
    ?>
    <tr>
      <td><?php echo $count++; ?></td>
      <td><?php echo htmlspecialchars($row['name']); ?></td>
      <td><?php echo htmlspecialchars($row['email']); ?></td>
      <td><?php echo htmlspecialchars($row['phone']); ?></td>
      <td><?php echo htmlspecialchars($row['host_name']); ?></td>
      <td><?php echo htmlspecialchars($row['purpose']); ?></td>
      <td>
        <?php
          $badge = [
            'expected' => 'secondary',
            'checked_in' => 'success',
            'checked_out' => 'dark',
            'returning' => 'info'
          ];
          $status = $row['status'];
          echo "<span class='badge bg-{$badge[$status]}'>{$status}</span>";
        ?>
      </td>
      <td><?php echo $row['checkin_time']; ?></td>
      <td><?php echo $row['checkout_time']; ?></td>
      <td>
        <?php if ($row['status'] === 'checked_in' || $row['status'] === 'returning'): ?>
          <a href="?checkout=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger"
             onclick="return confirm('Confirm check-out?');">Check-out</a>
        <?php elseif ($row['status'] === 'checked_out'): ?>
          <span class="text-muted">Completed</span>
        <?php else: ?>
          <span class="text-muted">Awaiting arrival</span>
        <?php endif; ?>
      </td>
    </tr>
    <?php endwhile; ?>
  </tbody>
</table>
</div>

<div class="modal fade" id="addVisitorModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Add / Check-in Visitor</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Visitor Name</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Phone</label>
          <input type="text" name="phone" class="form-control">
        </div>
        <div class="mb-3">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control">
        </div>
        <div class="mb-3">
          <label class="form-label">Host</label>
          <select name="host_id" class="form-select" required>
            <option value="">-- Select Host --</option>
            <?php
              $hosts = $conn->query("SELECT * FROM hosts ORDER BY name ASC");
              while ($h = $hosts->fetch_assoc()) {
                  echo "<option value='{$h['id']}'>{$h['name']}</option>";
              }
            ?>
          </select>
        </div>
        <div class="mb-3">
          <label class="form-label">Purpose</label>
          <textarea name="purpose" class="form-control"></textarea>
        </div>
        <div class="mb-3">
          <label class="form-label">Visit Type</label>
          <select name="type" class="form-select">
            <option value="checkin">Check-in</option>
            <option value="expected">Expected Visitor</option>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="add_visitor" class="btn btn-success">Save</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </form>
  </div>
</div>

<?php include "../includes/footer.php"; ?>
