<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

// Handle delete (cancel check-in)
if (isset($_GET['delete_id'])) {
    // Only allow Admin or Receptionist to delete
    if (in_array($_SESSION['role'], ['admin_officer', 'receptionist', 'system_admin'])) {
        $id = (int)$_GET['delete_id'];
        $conn->query("DELETE FROM visitors WHERE id=$id AND status='checked_in'");
        echo "<div class='alert alert-success'>Visitor check-in record deleted successfully.</div>";
    } else {
        echo "<div class='alert alert-danger'>Access Denied: You do not have permission to delete records.</div>";
    }
}

// Fetch active visitors
$active = $conn->query("
    SELECT v.id, v.name, v.phone, v.email, v.company, v.checkin_date, v.checkin_time, e.name AS host
    FROM visitors v
    LEFT JOIN employees e ON e.id = v.host_id
    WHERE v.status='checked_in'
    ORDER BY v.checkin_date DESC, v.checkin_time DESC
");
?>

<h3 class="mb-4">Currently Checked-In Visitors</h3>

<div class="card shadow-sm border-0 p-3">
  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Company</th>
          <th>Phone</th>
          <th>Host</th>
          <th>Check-In Date</th>
          <th>Check-In Time</th>
          <?php if (in_array($_SESSION['role'], ['admin_officer', 'receptionist', 'system_admin'])): ?>
            <th>Action</th>
          <?php endif; ?>
        </tr>
      </thead>
      <tbody>
      <?php $i=1; while ($r = $active->fetch_assoc()): ?>
        <tr>
          <td><?php echo $i++; ?></td>
          <td><?php echo htmlspecialchars($r['name']); ?></td>
          <td><?php echo htmlspecialchars($r['company']); ?></td>
          <td><?php echo htmlspecialchars($r['phone']); ?></td>
          <td><?php echo htmlspecialchars($r['host']); ?></td>
          <td><?php echo htmlspecialchars($r['checkin_date']); ?></td>
          <td><?php echo htmlspecialchars($r['checkin_time']); ?></td>
          <?php if (in_array($_SESSION['role'], ['admin_officer', 'receptionist', 'system_admin'])): ?>
          <td>
            <a href="?delete_id=<?php echo $r['id']; ?>"
               class="btn btn-sm btn-outline-danger"
               onclick="return confirm('Are you sure you want to delete this record?');">
               <i class="bi bi-trash"></i>
            </a>
          </td>
          <?php endif; ?>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
