<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/notify.php';

if (function_exists('require_roles')) {
    require_roles([
        'admin_officer','receptionist','system_admin',
        'it_officer','hse_officer','cso','pa'
    ]);
}

$msg = $err = "";

/* ---------------------------------------------------------
   HANDLE INDUCTION SUBMISSION
---------------------------------------------------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['induct'])) {

    $name    = trim($_POST['name']);
    $phone   = trim($_POST['phone']);
    $email   = trim($_POST['email']);
    $company = trim($_POST['organization'] ?? '');

    if ($name === '' || $phone === '') {
        $err = "Name and phone number are required.";

    } else {

        // Check if already inducted
        $check = $conn->prepare("
            SELECT * FROM induction 
            WHERE phone=? OR (email<>'' AND email=?) 
            LIMIT 1
        ");
        $check->bind_param("ss", $phone, $email);
        $check->execute();
        $found = $check->get_result()->fetch_assoc();

        if ($found) {
            $msg = "Visitor already inducted on " . $found['induction_date'] . ".";

        } else {

            $today = date('Y-m-d');

            $stmt = $conn->prepare("
                INSERT INTO induction (name, phone, email, company, induction_date, status)
                VALUES (?, ?, ?, ?, ?, 'pending')
            ");
            $stmt->bind_param("sssss", $name, $phone, $email, $company, $today);

            if ($stmt->execute()) {
                $msg = "Visitor inducted successfully.";
                @notify_induction_completed($name, $phone, $email, $company);
            } else {
                $err = "Failed to save induction.";
            }
        }
    }
}

/* ---------------------------------------------------------
   FETCH RECENT INDUCTIONS (FIXED)
---------------------------------------------------------- */
$recent = $conn->query("
    SELECT * FROM induction
    WHERE status IN ('pending','inducted')
    ORDER BY id DESC
    LIMIT 20
");
?>

<h3 class="mb-4">Visitor Induction</h3>

<?php if ($msg): ?>
<div class="alert alert-success"><?php echo $msg; ?></div>
<?php endif; ?>

<?php if ($err): ?>
<div class="alert alert-danger"><?php echo $err; ?></div>
<?php endif; ?>

<div class="card p-4 mb-4 shadow-sm border-0">
  <form method="POST">
    <div class="row g-3">

      <div class="col-md-3">
        <label class="form-label">Full Name</label>
        <input type="text" name="name" class="form-control" required>
      </div>

      <div class="col-md-3">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" class="form-control" required>
      </div>

      <div class="col-md-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control">
      </div>

      <div class="col-md-3">
        <label class="form-label">Organization (optional)</label>
        <input type="text" name="organization" class="form-control">
      </div>

    </div>

    <div class="mt-3 text-end">
      <button type="submit" name="induct" class="btn btn-success px-4">
        Save Induction
      </button>
    </div>
  </form>
</div>

<div class="card p-3 shadow-sm border-0 mt-4">
  <h5 class="text-primary mb-3">Recent Inductions</h5>

  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Phone</th>
          <th>Email</th>
          <th>Organization</th>
          <th>Induction Date</th>
          <th>Status</th>
          <th>Action</th>
        </tr>
      </thead>

      <tbody>
      <?php 
      $i = 1;
      while ($r = $recent->fetch_assoc()):
          $status = strtolower($r['status']);
          $badge  = ($status === 'inducted') ? 'success' : 'secondary';
      ?>
        <tr>
          <td><?php echo $i++; ?></td>
          <td><?php echo htmlspecialchars($r['name']); ?></td>
          <td><?php echo htmlspecialchars($r['phone']); ?></td>
          <td><?php echo htmlspecialchars($r['email']); ?></td>
          <td><?php echo htmlspecialchars($r['company'] ?: '-'); ?></td>
          <td><?php echo htmlspecialchars($r['induction_date']); ?></td>
          <td><span class="badge bg-<?php echo $badge; ?>"><?php echo ucfirst($status); ?></span></td>

          <td>
            <?php if ($status === 'pending'): ?>
              <a class="btn btn-sm btn-outline-primary"
                 href="/receptionist/visitors_add.php?prefill_name=<?php echo urlencode($r['name']); ?>&prefill_phone=<?php echo urlencode($r['phone']); ?>&prefill_email=<?php echo urlencode($r['email']); ?>">
                 Proceed to Check-In
              </a>
            <?php else: ?>
              <span class="text-success fw-semibold">Checked-In</span>
            <?php endif; ?>
          </td>

        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>